"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldEditorFlyoutContent = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../constants");
var _confirm_modals = require("./confirm_modals");
var _field_editor = require("./field_editor/field_editor");
var _field_editor_context = require("./field_editor_context");
var _flyout_panels = require("./flyout_panels");
var _preview = require("./preview");
var _state_utils = require("../state_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const i18nTexts = {
  cancelButtonLabel: _i18n.i18n.translate('indexPatternFieldEditor.editor.flyoutCancelButtonLabel', {
    defaultMessage: 'Cancel'
  }),
  saveButtonLabel: _i18n.i18n.translate('indexPatternFieldEditor.editor.flyoutSaveButtonLabel', {
    defaultMessage: 'Save'
  })
};
const defaultModalVisibility = {
  confirmChangeNameOrType: false,
  confirmUnsavedChanges: false
};
const isPanelVisibleSelector = state => state.isPanelVisible;
const FieldEditorFlyoutContentComponent = ({
  fieldToEdit,
  fieldToCreate,
  onSave,
  onCancel,
  isSavingField,
  onMounted
}) => {
  const isMounted = (0, _react.useRef)(false);
  const isEditingExistingField = !!fieldToEdit;
  const {
    dataView,
    subfields$
  } = (0, _field_editor_context.useFieldEditorContext)();
  const isMobile = (0, _eui.useIsWithinMaxBreakpoint)('s');
  const {
    controller
  } = (0, _preview.useFieldPreviewContext)();
  const isPanelVisible = (0, _state_utils.useStateSelector)(controller.state$, isPanelVisibleSelector);
  const [formState, setFormState] = (0, _react.useState)({
    isSubmitted: false,
    isSubmitting: false,
    isValid: fieldToEdit ? true : undefined,
    submit: fieldToEdit ? async () => ({
      isValid: true,
      data: fieldToEdit
    }) : async () => ({
      isValid: false,
      data: {}
    })
  });
  const [modalVisibility, setModalVisibility] = (0, _react.useState)(defaultModalVisibility);
  const [isFormModified, setIsFormModified] = (0, _react.useState)(false);
  const {
    submit,
    isValid: isFormValid,
    isSubmitting
  } = formState;
  const hasErrors = isFormValid === false;
  const canCloseValidator = (0, _react.useCallback)(() => {
    if (isFormModified) {
      setModalVisibility({
        ...defaultModalVisibility,
        confirmUnsavedChanges: true
      });
    }
    return !isFormModified;
  }, [isFormModified]);
  const onClickSave = (0, _react.useCallback)(async () => {
    const {
      isValid,
      data: updatedField
    } = await submit();
    if (!isMounted.current) {
      // User has closed the flyout meanwhile submitting the form
      return;
    }
    if (isValid) {
      const nameChange = (fieldToEdit === null || fieldToEdit === void 0 ? void 0 : fieldToEdit.name) !== updatedField.name;
      const typeChange = (fieldToEdit === null || fieldToEdit === void 0 ? void 0 : fieldToEdit.type) !== updatedField.type;
      if (isEditingExistingField && (nameChange || typeChange)) {
        setModalVisibility({
          ...defaultModalVisibility,
          confirmChangeNameOrType: true
        });
      } else {
        if (updatedField.type === 'composite') {
          onSave({
            ...updatedField,
            fields: subfields$.getValue()
          });
        } else {
          onSave(updatedField);
        }
      }
    }
  }, [onSave, submit, fieldToEdit, isEditingExistingField, subfields$]);
  const onClickCancel = (0, _react.useCallback)(() => {
    const canClose = canCloseValidator();
    if (canClose) {
      onCancel();
    }
  }, [onCancel, canCloseValidator]);
  const renderModal = () => {
    if (modalVisibility.confirmChangeNameOrType) {
      return /*#__PURE__*/_react.default.createElement(_confirm_modals.SaveFieldTypeOrNameChangedModal, {
        fieldName: fieldToEdit === null || fieldToEdit === void 0 ? void 0 : fieldToEdit.name,
        onConfirm: async () => {
          const {
            data: updatedField
          } = await submit();
          if (updatedField.type === 'composite') {
            onSave({
              ...updatedField,
              fields: subfields$.getValue()
            });
          } else {
            onSave(updatedField);
          }
        },
        onCancel: () => {
          setModalVisibility(defaultModalVisibility);
        }
      });
    }
    if (modalVisibility.confirmUnsavedChanges) {
      return /*#__PURE__*/_react.default.createElement(_confirm_modals.ModifiedFieldModal, {
        onConfirm: () => {
          setModalVisibility(defaultModalVisibility);
          onCancel();
        },
        onCancel: () => {
          setModalVisibility(defaultModalVisibility);
        }
      });
    }
    return null;
  };
  (0, _react.useEffect)(() => {
    if (onMounted) {
      // When the flyout mounts we send to the parent the validator to check
      // if we can close the flyout or not (and display a confirm modal if needed).
      // This is required to display the confirm modal when clicking outside the flyout.
      onMounted({
        canCloseValidator
      });
      return () => {
        onMounted({
          canCloseValidator: () => true
        });
      };
    }
  }, [onMounted, canCloseValidator]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Group, {
    flyoutClassName: _constants.euiFlyoutClassname,
    maxWidth: isMobile ? false : 1180,
    "data-test-subj": "fieldEditor",
    fixedPanelWidths: true
  }, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Item, {
    width: 600
  }, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Content, null, /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Header, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    "data-test-subj": "flyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, fieldToEdit ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternFieldEditor.editor.flyoutEditFieldTitle",
    defaultMessage: "Edit field '{fieldName}'",
    values: {
      fieldName: fieldToEdit.name
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternFieldEditor.editor.flyoutDefaultTitle",
    defaultMessage: "Create field"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternFieldEditor.editor.flyoutEditFieldSubtitle",
    defaultMessage: "Data view: {patternName}",
    values: {
      patternName: /*#__PURE__*/_react.default.createElement("i", null, dataView.getName())
    }
  })))), /*#__PURE__*/_react.default.createElement(_field_editor.FieldEditor, {
    field: fieldToEdit !== null && fieldToEdit !== void 0 ? fieldToEdit : fieldToCreate,
    onChange: setFormState,
    onFormModifiedChange: setIsFormModified
  })), /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Footer, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: onClickCancel,
    "data-test-subj": "closeFlyoutButton"
  }, i18nTexts.cancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: onClickSave,
    "data-test-subj": "fieldSaveButton",
    fill: true,
    disabled: hasErrors,
    isLoading: isSavingField || isSubmitting
  }, i18nTexts.saveButtonLabel)))))), isPanelVisible && /*#__PURE__*/_react.default.createElement(_flyout_panels.FlyoutPanels.Item, {
    width: 440,
    backgroundColor: "euiPageBackground",
    border: "left",
    "data-test-subj": "previewPanel"
  }, /*#__PURE__*/_react.default.createElement(_preview.FieldPreview, null))), renderModal());
};
const FieldEditorFlyoutContent = exports.FieldEditorFlyoutContent = /*#__PURE__*/_react.default.memo(FieldEditorFlyoutContentComponent);