"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.esqlSearchStrategyProvider = void 0;
var _rxjs = require("rxjs");
var _report_search_error = require("../../report_search_error");
var _sanitize_request_params = require("../../sanitize_request_params");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const esqlSearchStrategyProvider = (logger, useInternalUser = false) => ({
  /**
   * @param request
   * @param options
   * @param deps
   * @throws `KbnSearchError`
   * @returns `Observable<IEsSearchResponse<any>>`
   */
  search: (request, {
    abortSignal,
    ...options
  }, {
    esClient,
    uiSettingsClient
  }) => {
    // Only default index pattern type is supported here.
    // See ese for other type support.
    if (request.indexType) {
      throw new _report_search_error.KbnSearchError(`Unsupported index pattern type ${request.indexType}`, 400);
    }
    const search = async () => {
      try {
        var _request$params, _options$transport, _meta$request, _meta$request2;
        // `drop_null_columns` is going to change the response
        // now we get `all_columns` and `columns`
        // `columns` contain only columns with data
        // `all_columns` contain everything
        const {
          terminateAfter,
          dropNullColumns,
          ...requestParams
        } = (_request$params = request.params) !== null && _request$params !== void 0 ? _request$params : {};
        const {
          headers,
          body,
          meta
        } = await esClient.asCurrentUser.transport.request({
          method: 'POST',
          path: `/_query`,
          querystring: dropNullColumns ? 'drop_null_columns' : '',
          body: {
            ...requestParams
          }
        }, {
          signal: abortSignal,
          meta: true,
          // we don't want the ES client to retry (default value is 3)
          maxRetries: 0,
          requestTimeout: (_options$transport = options.transport) === null || _options$transport === void 0 ? void 0 : _options$transport.requestTimeout
        });
        return {
          rawResponse: body,
          isPartial: false,
          isRunning: false,
          ...(meta !== null && meta !== void 0 && (_meta$request = meta.request) !== null && _meta$request !== void 0 && _meta$request.params ? {
            requestParams: (0, _sanitize_request_params.sanitizeRequestParams)(meta === null || meta === void 0 ? void 0 : (_meta$request2 = meta.request) === null || _meta$request2 === void 0 ? void 0 : _meta$request2.params)
          } : {}),
          warning: headers === null || headers === void 0 ? void 0 : headers.warning
        };
      } catch (e) {
        throw (0, _report_search_error.getKbnSearchError)(e);
      }
    };
    return (0, _rxjs.from)(search());
  }
});
exports.esqlSearchStrategyProvider = esqlSearchStrategyProvider;