"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;
var _saved_objects = require("../saved_objects");
var queryPersistableState = _interopRequireWildcard(require("../../common/query/persistable_state"));
var filtersPersistableState = _interopRequireWildcard(require("../../common/query/filters/persistable_state"));
var _routes = require("./routes");
var _route_handler_context = require("./route_handler_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * @internal
 */
class QueryService {
  setup(core) {
    core.savedObjects.registerType(_saved_objects.querySavedObjectType);
    core.http.registerRouteHandlerContext('savedQuery', _route_handler_context.registerSavedQueryRouteHandlerContext);
    (0, _routes.registerSavedQueryRoutes)(core);
    return {
      extract: queryPersistableState.extract,
      inject: queryPersistableState.inject,
      telemetry: queryPersistableState.telemetry,
      getAllMigrations: queryPersistableState.getAllMigrations,
      filterManager: {
        extract: filtersPersistableState.extract,
        inject: filtersPersistableState.inject,
        telemetry: filtersPersistableState.telemetry,
        getAllMigrations: filtersPersistableState.getAllMigrations
      }
    };
  }
  start() {}
}
exports.QueryService = QueryService;