"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAction = void 0;
var _delete_button = require("./delete_button");
var _extend_button = require("./extend_button");
var _inspect_button = require("./inspect_button");
var _types = require("./types");
var _rename_button = require("./rename_button");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getAction = (api, actionType, uiSession, core) => {
  switch (actionType) {
    case _types.ACTION.INSPECT:
      return (0, _inspect_button.createInspectActionDescriptor)(api, uiSession, core);
    case _types.ACTION.DELETE:
      return (0, _delete_button.createDeleteActionDescriptor)(api, uiSession, core);
    case _types.ACTION.EXTEND:
      return (0, _extend_button.createExtendActionDescriptor)(api, uiSession, core);
    case _types.ACTION.RENAME:
      return (0, _rename_button.createRenameActionDescriptor)(api, uiSession, core);
    default:
      // eslint-disable-next-line no-console
      console.error(`Unknown action: ${actionType}`);
  }

  // Unknown action: do not show

  return null;
};
exports.getAction = getAction;