"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
var _filter_manager = require("./filter_manager");
var _lib = require("./lib");
var _timefilter = require("./timefilter");
var _saved_query_service = require("./saved_query/saved_query_service");
var _create_query_state_observable = require("./state_sync/create_query_state_observable");
var _query_state = require("./query_state");
var _query_string = require("./query_string");
var _common = require("../../common");
var _services = require("../services");
var _persistable_state = require("../../common/query/persistable_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Query Service
 * @internal
 */
class QueryService {
  constructor() {
    (0, _defineProperty2.default)(this, "filterManager", void 0);
    (0, _defineProperty2.default)(this, "timefilter", void 0);
    (0, _defineProperty2.default)(this, "queryStringManager", void 0);
    (0, _defineProperty2.default)(this, "state$", void 0);
    (0, _defineProperty2.default)(this, "extract", _persistable_state.extract);
    (0, _defineProperty2.default)(this, "inject", _persistable_state.inject);
    (0, _defineProperty2.default)(this, "telemetry", _persistable_state.telemetry);
    (0, _defineProperty2.default)(this, "getAllMigrations", _persistable_state.getAllMigrations);
    (0, _defineProperty2.default)(this, "migrateToLatest", versionedState => {
      // Argument of type 'VersionedState<Serializable>' is not assignable to parameter of type 'VersionedState<QueryState>'.
      return (0, _persistable_state.migrateToLatest)(versionedState);
    });
  }
  setup({
    storage,
    uiSettings,
    nowProvider
  }) {
    this.filterManager = new _filter_manager.FilterManager(uiSettings);
    const timefilterService = new _timefilter.TimefilterService(nowProvider);
    this.timefilter = timefilterService.setup({
      uiSettings,
      storage
    });
    this.queryStringManager = new _query_string.QueryStringManager(storage, uiSettings);
    this.state$ = (0, _create_query_state_observable.createQueryStateObservable)({
      filterManager: this.filterManager,
      timefilter: this.timefilter,
      queryString: this.queryStringManager
    }).pipe((0, _rxjs.share)());
    return {
      filterManager: this.filterManager,
      timefilter: this.timefilter,
      queryString: this.queryStringManager,
      state$: this.state$,
      getState: () => this.getQueryState(),
      ...this.getPersistableStateMethods()
    };
  }
  start({
    storage,
    uiSettings,
    http
  }) {
    return {
      addToQueryLog: (0, _lib.createAddToQueryLog)({
        storage,
        uiSettings
      }),
      filterManager: this.filterManager,
      queryString: this.queryStringManager,
      savedQueries: (0, _saved_query_service.createSavedQueryService)(http),
      state$: this.state$,
      getState: () => this.getQueryState(),
      timefilter: this.timefilter,
      getEsQuery: (indexPattern, timeRange) => {
        const timeFilter = this.timefilter.timefilter.createFilter(indexPattern, timeRange);
        return (0, _esQuery.buildEsQuery)(indexPattern, this.queryStringManager.getQuery(), [...this.filterManager.getFilters(), ...(timeFilter ? [timeFilter] : [])], (0, _common.getEsQueryConfig)((0, _services.getUiSettings)()));
      },
      ...this.getPersistableStateMethods()
    };
  }
  stop() {
    // nothing to do here yet
  }
  getQueryState() {
    return (0, _query_state.getQueryState)({
      timefilter: this.timefilter,
      queryString: this.queryStringManager,
      filterManager: this.filterManager
    });
  }
  getPersistableStateMethods() {
    return {
      extract: this.extract.bind(this),
      inject: this.inject.bind(this),
      telemetry: this.telemetry.bind(this),
      migrateToLatest: this.migrateToLatest.bind(this),
      getAllMigrations: this.getAllMigrations.bind(this)
    };
  }
}
exports.QueryService = QueryService;