"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDisplayValueFromFilter = getDisplayValueFromFilter;
exports.getFieldDisplayValueFromFilter = getFieldDisplayValueFromFilter;
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _map_phrase = require("./mappers/map_phrase");
var _map_phrases = require("./mappers/map_phrases");
var _map_range = require("./mappers/map_range");
var _get_index_pattern_from_filter = require("./get_index_pattern_from_filter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getValueFormatter(indexPattern, key) {
  // checking getFormatterForField exists because there is at least once case where an index pattern
  // is an object rather than an IndexPattern class
  if (!indexPattern || !('getFormatterForField' in indexPattern) || !key) return;
  const field = indexPattern.fields.find(f => f.name === key);
  if (!field) {
    throw new Error(_i18n.i18n.translate('data.filter.filterBar.fieldNotFound', {
      defaultMessage: 'Field {key} not found in data view {dataView}',
      values: {
        key,
        dataView: indexPattern.title
      }
    }));
  }
  return indexPattern.getFormatterForField(field);
}
function getFieldDisplayValueFromFilter(filter, indexPatterns) {
  var _customLabel;
  const indexPattern = (0, _get_index_pattern_from_filter.getIndexPatternFromFilter)(filter, indexPatterns);
  if (!indexPattern) return '';
  const fieldName = (0, _esQuery.getFilterField)(filter);
  if (!fieldName) return '';
  const field = indexPattern.fields.find(f => f.name === fieldName);
  return field && 'customLabel' in field ? (_customLabel = field.customLabel) !== null && _customLabel !== void 0 ? _customLabel : '' : '';
}
function getDisplayValueFromFilter(filter, indexPatterns) {
  var _filter$meta$value;
  const indexPattern = (0, _get_index_pattern_from_filter.getIndexPatternFromFilter)(filter, indexPatterns);
  const fieldName = (0, _esQuery.getFilterField)(filter);
  const field = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.fields.find(f => f.name === fieldName);
  const fieldType = field === null || field === void 0 ? void 0 : field.type;
  const valueFormatter = getValueFormatter(indexPattern, fieldName);
  if ((0, _esQuery.isPhraseFilter)(filter) || (0, _esQuery.isScriptedPhraseFilter)(filter)) {
    return (0, _map_phrase.getPhraseDisplayValue)(filter, valueFormatter, fieldType);
  } else if ((0, _esQuery.isPhrasesFilter)(filter)) {
    return (0, _map_phrases.getPhrasesDisplayValue)(filter, valueFormatter);
  } else if ((0, _esQuery.isRangeFilter)(filter) || (0, _esQuery.isScriptedRangeFilter)(filter)) {
    return (0, _map_range.getRangeDisplayValue)(filter, valueFormatter);
  } else return (_filter$meta$value = filter.meta.value) !== null && _filter$meta$value !== void 0 ? _filter$meta$value : '';
}