"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.aggregateQueryToAst = void 0;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/expressions-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const aggregateQueryToAst = ({
  query,
  timeField,
  titleForInspector,
  descriptionForInspector
}) => {
  if ('sql' in query) {
    return (0, _common.buildExpressionFunction)('essql', {
      query: query.sql,
      timeField
    }).toAst();
  }
  if ('esql' in query) {
    return (0, _common.buildExpressionFunction)('esql', {
      query: query.esql,
      timeField,
      locale: _i18n.i18n.getLocale(),
      titleForInspector,
      descriptionForInspector
    }).toAst();
  }
};
exports.aggregateQueryToAst = aggregateQueryToAst;