"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteDashboards = void 0;
var _dashboard_constants = require("../../../dashboard_constants");
var _dashboard_content_management_service = require("../dashboard_content_management_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const deleteDashboards = async (ids, contentManagement) => {
  const deletePromises = ids.map(id => {
    _dashboard_content_management_service.dashboardContentManagementCache.deleteDashboard(id);
    return contentManagement.client.delete({
      contentTypeId: _dashboard_constants.DASHBOARD_CONTENT_ID,
      id
    });
  });
  await Promise.all(deletePromises);
};
exports.deleteDashboards = deleteDashboards;