"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkForDuplicateDashboardTitle = checkForDuplicateDashboardTitle;
var _dashboard_constants = require("../../../dashboard_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * check for an existing dashboard with the same title in ES
 * returns Promise<true> when there is no duplicate, or runs the provided onTitleDuplicate
 * function when the title already exists
 */
async function checkForDuplicateDashboardTitle({
  title,
  copyOnSave,
  lastSavedTitle,
  onTitleDuplicate,
  isTitleDuplicateConfirmed
}, contentManagement) {
  // Don't check for duplicates if user has already confirmed save with duplicate title
  if (isTitleDuplicateConfirmed) {
    return true;
  }

  // Don't check if the user isn't updating the title, otherwise that would become very annoying to have
  // to confirm the save every time, except when copyOnSave is true, then we do want to check.
  if (title === lastSavedTitle && !copyOnSave) {
    return true;
  }
  const {
    hits
  } = await contentManagement.client.search({
    contentTypeId: _dashboard_constants.DASHBOARD_CONTENT_ID,
    query: {
      text: title ? `${title}*` : undefined,
      limit: 10
    },
    options: {
      onlyTitle: true
    }
  });
  const duplicate = hits.find(hit => hit.attributes.title.toLowerCase() === title.toLowerCase());
  if (!duplicate) {
    return true;
  }
  onTitleDuplicate === null || onTitleDuplicate === void 0 ? void 0 : onTitleDuplicate();
  return false;
}