"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InternalDashboardTopNav = InternalDashboardTopNav;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/presentation-util-plugin/public");
var _managedContentBadge = require("@kbn/managed-content-badge");
var _public2 = require("@kbn/embeddable-plugin/public");
var _eui = require("@elastic/eui");
var _dashboard_app_strings = require("../dashboard_app/_dashboard_app_strings");
var _common = require("../../common");
var _dashboard_app = require("../dashboard_app/dashboard_app");
var _plugin_services = require("../services/plugin_services");
var _use_dashboard_menu_items = require("../dashboard_app/top_nav/use_dashboard_menu_items");
var _dashboard_editing_toolbar = require("../dashboard_app/top_nav/dashboard_editing_toolbar");
var _dashboard_mount_context = require("../dashboard_app/hooks/dashboard_mount_context");
var _dashboard_constants = require("../dashboard_constants");
require("./_dashboard_top_nav.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const LabsFlyout = (0, _public.withSuspense)(_public.LazyLabsFlyout, null);
function InternalDashboardTopNav({
  customLeadingBreadCrumbs = [],
  embedSettings,
  forceHideUnifiedSearch,
  redirectTo,
  setCustomHeaderActionMenu,
  showBorderBottom = true,
  showResetChange = true
}) {
  const [isChromeVisible, setIsChromeVisible] = (0, _react.useState)(false);
  const [isLabsShown, setIsLabsShown] = (0, _react.useState)(false);
  const dashboardTitleRef = (0, _react.useRef)(null);

  /**
   * Unpack dashboard services
   */
  const {
    data: {
      query: {
        filterManager
      }
    },
    chrome: {
      setBreadcrumbs,
      setIsVisible: setChromeVisibility,
      getIsVisible$: getChromeIsVisible$,
      recentlyAccessed: chromeRecentlyAccessed
    },
    serverless,
    settings: {
      uiSettings
    },
    navigation: {
      TopNavMenu
    },
    embeddable: {
      getStateTransfer
    },
    initializerContext: {
      allowByValueEmbeddables
    },
    dashboardCapabilities: {
      saveQuery: allowSaveQuery,
      showWriteControls
    }
  } = _plugin_services.pluginServices.getServices();
  const isLabsEnabled = uiSettings.get(_common.UI_SETTINGS.ENABLE_LABS_UI);
  const {
    setHeaderActionMenu,
    onAppLeave
  } = (0, _dashboard_mount_context.useDashboardMountContext)();
  const dashboard = (0, _dashboard_app.useDashboardAPI)();
  const PresentationUtilContextProvider = (0, _public.getContextProvider)();
  const hasRunMigrations = dashboard.select(state => state.componentState.hasRunClientsideMigrations);
  const hasUnsavedChanges = dashboard.select(state => state.componentState.hasUnsavedChanges);
  const fullScreenMode = dashboard.select(state => state.componentState.fullScreenMode);
  const savedQueryId = dashboard.select(state => state.componentState.savedQueryId);
  const lastSavedId = dashboard.select(state => state.componentState.lastSavedId);
  const focusedPanelId = dashboard.select(state => state.componentState.focusedPanelId);
  const managed = dashboard.select(state => state.componentState.managed);
  const viewMode = dashboard.select(state => state.explicitInput.viewMode);
  const query = dashboard.select(state => state.explicitInput.query);
  const title = dashboard.select(state => state.explicitInput.title);

  // store data views in state & subscribe to dashboard data view changes.
  const [allDataViews, setAllDataViews] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    setAllDataViews(dashboard.getAllDataViews());
    const subscription = dashboard.onDataViewsUpdate$.subscribe(dataViews => setAllDataViews(dataViews));
    return () => subscription.unsubscribe();
  }, [dashboard]);
  const dashboardTitle = (0, _react.useMemo)(() => {
    return (0, _dashboard_app_strings.getDashboardTitle)(title, viewMode, !lastSavedId);
  }, [title, viewMode, lastSavedId]);

  /**
   * focus on the top header when title or view mode is changed
   */
  (0, _react.useEffect)(() => {
    var _dashboardTitleRef$cu;
    (_dashboardTitleRef$cu = dashboardTitleRef.current) === null || _dashboardTitleRef$cu === void 0 ? void 0 : _dashboardTitleRef$cu.focus();
  }, [title, viewMode]);

  /**
   * Manage chrome visibility when dashboard is embedded.
   */
  (0, _react.useEffect)(() => {
    if (!embedSettings) setChromeVisibility(viewMode !== _public2.ViewMode.PRINT);
  }, [embedSettings, setChromeVisibility, viewMode]);

  /**
   * populate recently accessed, and set is chrome visible.
   */
  (0, _react.useEffect)(() => {
    const subscription = getChromeIsVisible$().subscribe(visible => setIsChromeVisible(visible));
    if (lastSavedId && title) {
      chromeRecentlyAccessed.add((0, _dashboard_constants.getFullEditPath)(lastSavedId, viewMode === _public2.ViewMode.EDIT), title, lastSavedId);
    }
    return () => subscription.unsubscribe();
  }, [allowByValueEmbeddables, chromeRecentlyAccessed, getChromeIsVisible$, lastSavedId, viewMode, title]);

  /**
   * Set breadcrumbs to dashboard title when dashboard's title or view mode changes
   */
  (0, _react.useEffect)(() => {
    const dashboardTitleBreadcrumbs = [{
      text: viewMode === _public2.ViewMode.EDIT ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dashboardTitle, " ", /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "s",
        type: "pencil"
      })) : dashboardTitle,
      onClick: viewMode === _public2.ViewMode.EDIT ? () => {
        dashboard.showSettings();
      } : undefined
    }];
    if (serverless !== null && serverless !== void 0 && serverless.setBreadcrumbs) {
      // set serverless breadcrumbs if available,
      // set only the dashboardTitleBreadcrumbs because the main breadcrumbs automatically come as part of the navigation config
      serverless.setBreadcrumbs(dashboardTitleBreadcrumbs);
    } else {
      /**
       * non-serverless regular breadcrumbs
       * Dashboard embedded in other plugins (e.g. SecuritySolution)
       * will have custom leading breadcrumbs for back to their app.
       **/
      setBreadcrumbs(customLeadingBreadCrumbs.concat([{
        text: (0, _dashboard_app_strings.getDashboardBreadcrumb)(),
        'data-test-subj': 'dashboardListingBreadcrumb',
        onClick: () => {
          redirectTo({
            destination: 'listing'
          });
        }
      }, ...dashboardTitleBreadcrumbs]));
    }
  }, [setBreadcrumbs, redirectTo, dashboardTitle, dashboard, viewMode, serverless, customLeadingBreadCrumbs]);

  /**
   * Build app leave handler whenever hasUnsavedChanges changes
   */
  (0, _react.useEffect)(() => {
    onAppLeave(actions => {
      if (viewMode === _public2.ViewMode.EDIT && hasUnsavedChanges && !getStateTransfer().isTransferInProgress) {
        return actions.confirm(_dashboard_app_strings.leaveConfirmStrings.getLeaveSubtitle(), _dashboard_app_strings.leaveConfirmStrings.getLeaveTitle());
      }
      return actions.default();
    });
    return () => {
      // reset on app leave handler so leaving from the listing page doesn't trigger a confirmation
      onAppLeave(actions => actions.default());
    };
  }, [onAppLeave, getStateTransfer, hasUnsavedChanges, viewMode]);
  const visibilityProps = (0, _react.useMemo)(() => {
    const shouldShowNavBarComponent = forceShow => (forceShow || isChromeVisible) && !fullScreenMode;
    const shouldShowFilterBar = forceHide => !forceHide && (filterManager.getFilters().length > 0 || !fullScreenMode);
    const showTopNavMenu = shouldShowNavBarComponent(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowTopNavMenu));
    const showQueryInput = Boolean(forceHideUnifiedSearch) ? false : shouldShowNavBarComponent(Boolean((embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowQueryInput) || viewMode === _public2.ViewMode.PRINT));
    const showDatePicker = Boolean(forceHideUnifiedSearch) ? false : shouldShowNavBarComponent(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceShowDatePicker));
    const showFilterBar = shouldShowFilterBar(Boolean(embedSettings === null || embedSettings === void 0 ? void 0 : embedSettings.forceHideFilterBar));
    const showQueryBar = showQueryInput || showDatePicker || showFilterBar;
    const showSearchBar = showQueryBar || showFilterBar;
    return {
      showTopNavMenu,
      showSearchBar,
      showFilterBar,
      showQueryInput,
      showDatePicker
    };
  }, [embedSettings, filterManager, forceHideUnifiedSearch, fullScreenMode, isChromeVisible, viewMode]);
  const {
    viewModeTopNavConfig,
    editModeTopNavConfig
  } = (0, _use_dashboard_menu_items.useDashboardMenuItems)({
    redirectTo,
    isLabsShown,
    setIsLabsShown,
    showResetChange
  });
  (0, _useUnmount.default)(() => {
    dashboard.clearOverlays();
  });
  const badges = (0, _react.useMemo)(() => {
    const allBadges = [];
    if (hasUnsavedChanges && viewMode === _public2.ViewMode.EDIT) {
      allBadges.push({
        'data-test-subj': 'dashboardUnsavedChangesBadge',
        badgeText: _dashboard_app_strings.unsavedChangesBadgeStrings.getUnsavedChangedBadgeText(),
        title: '',
        color: 'warning',
        toolTipProps: {
          content: _dashboard_app_strings.unsavedChangesBadgeStrings.getUnsavedChangedBadgeToolTipContent(),
          position: 'bottom'
        }
      });
    }
    if (hasRunMigrations && viewMode === _public2.ViewMode.EDIT) {
      allBadges.push({
        'data-test-subj': 'dashboardSaveRecommendedBadge',
        badgeText: _dashboard_app_strings.unsavedChangesBadgeStrings.getHasRunMigrationsText(),
        title: '',
        color: 'success',
        iconType: 'save',
        toolTipProps: {
          content: _dashboard_app_strings.unsavedChangesBadgeStrings.getHasRunMigrationsToolTipContent(),
          position: 'bottom'
        }
      });
    }
    if (showWriteControls && managed) {
      allBadges.push((0, _managedContentBadge.getManagedContentBadge)(_dashboard_app_strings.dashboardManagedBadge.getTooltip()));
    }
    return allBadges;
  }, [hasUnsavedChanges, viewMode, hasRunMigrations, showWriteControls, managed]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "dashboardTopNav"
  }, /*#__PURE__*/_react.default.createElement("h1", {
    id: "dashboardTitle",
    className: "euiScreenReaderOnly",
    ref: dashboardTitleRef,
    tabIndex: -1
  }, `${(0, _dashboard_app_strings.getDashboardBreadcrumb)()} - ${dashboardTitle}`), /*#__PURE__*/_react.default.createElement(TopNavMenu, (0, _extends2.default)({}, visibilityProps, {
    query: query,
    badges: badges,
    screenTitle: title,
    useDefaultBehaviors: true,
    savedQueryId: savedQueryId,
    indexPatterns: allDataViews,
    saveQueryMenuVisibility: allowSaveQuery ? 'allowed_by_app_privilege' : 'globally_managed',
    appName: _dashboard_constants.LEGACY_DASHBOARD_APP_ID,
    visible: viewMode !== _public2.ViewMode.PRINT,
    setMenuMountPoint: embedSettings || fullScreenMode ? setCustomHeaderActionMenu !== null && setCustomHeaderActionMenu !== void 0 ? setCustomHeaderActionMenu : undefined : setHeaderActionMenu,
    className: fullScreenMode ? 'kbnTopNavMenu-isFullScreen' : undefined,
    config: visibilityProps.showTopNavMenu ? viewMode === _public2.ViewMode.EDIT ? editModeTopNavConfig : viewModeTopNavConfig : undefined,
    onQuerySubmit: (_payload, isUpdate) => {
      if (isUpdate === false) {
        dashboard.forceRefresh();
      }
    },
    onSavedQueryIdChange: newId => dashboard.dispatch.setSavedQueryId(newId)
  })), viewMode !== _public2.ViewMode.PRINT && isLabsEnabled && isLabsShown ? /*#__PURE__*/_react.default.createElement(PresentationUtilContextProvider, null, /*#__PURE__*/_react.default.createElement(LabsFlyout, {
    solutions: ['dashboard'],
    onClose: () => setIsLabsShown(false)
  })) : null, viewMode === _public2.ViewMode.EDIT ? /*#__PURE__*/_react.default.createElement(_dashboard_editing_toolbar.DashboardEditingToolbar, {
    isDisabled: !!focusedPanelId
  }) : null, showBorderBottom && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none"
  }));
}