"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DashboardListing = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _contentManagementTableListView = require("@kbn/content-management-table-list-view");
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _public = require("@kbn/kibana-react-plugin/public");
var _plugin_services = require("../services/plugin_services");
var _dashboard_unsaved_listing = require("./dashboard_unsaved_listing");
var _use_dashboard_listing_table = require("./hooks/use_dashboard_listing_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DashboardListing = ({
  children,
  initialFilter,
  goToDashboard,
  getDashboardUrl,
  useSessionStorageIntegration
}) => {
  const {
    application,
    notifications,
    overlays,
    http,
    chrome: {
      theme
    },
    savedObjectsTagging,
    coreContext: {
      executionContext
    }
  } = _plugin_services.pluginServices.getServices();
  (0, _public.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'list'
  });
  const {
    unsavedDashboardIds,
    refreshUnsavedDashboards,
    tableListViewTableProps
  } = (0, _use_dashboard_listing_table.useDashboardListingTable)({
    goToDashboard,
    getDashboardUrl,
    useSessionStorageIntegration,
    initialFilter
  });
  const savedObjectsTaggingFakePlugin = (0, _react.useMemo)(() => {
    return savedObjectsTagging.hasApi // TODO: clean up this logic once https://github.com/elastic/kibana/issues/140433 is resolved
    ? {
      ui: savedObjectsTagging
    } : undefined;
  }, [savedObjectsTagging]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: {
      application: application,
      notifications,
      overlays,
      http,
      theme
    },
    toMountPoint: _public.toMountPoint,
    savedObjectsTagging: savedObjectsTaggingFakePlugin,
    FormattedRelative: _i18nReact.FormattedRelative
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListView.TableListView, tableListViewTableProps, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_dashboard_unsaved_listing.DashboardUnsavedListing, {
    goToDashboard: goToDashboard,
    unsavedDashboardIds: unsavedDashboardIds,
    refreshUnsavedDashboards: refreshUnsavedDashboards
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.DashboardListing = DashboardListing;
var _default = exports.default = DashboardListing;