"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startDashboardSearchSessionIntegration = startDashboardSearchSessionIntegration;
var _rxjs = require("rxjs");
var _public = require("@kbn/data-plugin/public");
var _plugin_services = require("../../../../services/plugin_services");
var _new_session = require("./new_session");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Enables dashboard search sessions.
 */
function startDashboardSearchSessionIntegration(searchSessionSettings) {
  if (!searchSessionSettings) return;
  const {
    data: {
      search: {
        session
      }
    },
    dashboardCapabilities: {
      storeSearchSession: canStoreSearchSession
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    sessionIdUrlChangeObservable,
    getSearchSessionIdFromURL,
    removeSessionIdFromUrl,
    createSessionRestorationDataProvider
  } = searchSessionSettings;
  session.enableStorage(createSessionRestorationDataProvider(this), {
    isDisabled: () => canStoreSearchSession ? {
      disabled: false
    } : {
      disabled: true,
      reasonText: _public.noSearchSessionStorageCapabilityMessage
    }
  });

  // force refresh when the session id in the URL changes. This will also fire off the "handle search session change" below.
  const searchSessionIdChangeSubscription = sessionIdUrlChangeObservable === null || sessionIdUrlChangeObservable === void 0 ? void 0 : sessionIdUrlChangeObservable.pipe((0, _rxjs.skip)(1)).subscribe(() => this.forceRefresh());
  (0, _new_session.newSession$)(this).subscribe(() => {
    const currentSearchSessionId = this.getState().explicitInput.searchSessionId;
    const updatedSearchSessionId = (_searchSessionIdFromU => {
      let searchSessionIdFromURL = getSearchSessionIdFromURL();
      if (searchSessionIdFromURL) {
        if (session.isRestore() && session.isCurrentSession(searchSessionIdFromURL)) {
          // we had previously been in a restored session but have now changed state so remove the session id from the URL.
          removeSessionIdFromUrl();
          searchSessionIdFromURL = undefined;
        } else {
          session.restore(searchSessionIdFromURL);
        }
      }
      return (_searchSessionIdFromU = searchSessionIdFromURL) !== null && _searchSessionIdFromU !== void 0 ? _searchSessionIdFromU : session.start();
    })();
    if (updatedSearchSessionId && updatedSearchSessionId !== currentSearchSessionId) {
      this.searchSessionId = updatedSearchSessionId;
      this.searchSessionId$.next(updatedSearchSessionId);
    }
  });
  this.integrationSubscriptions.add(searchSessionIdChangeSubscription);
}