"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.startSyncingDashboardDataViews = startSyncingDashboardDataViews;
var _presentationPublishing = require("@kbn/presentation-publishing");
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _plugin_services = require("../../../../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function startSyncingDashboardDataViews() {
  const {
    data: {
      dataViews
    }
  } = _plugin_services.pluginServices.getServices();
  const controlGroupDataViewsPipe = this.controlGroup ? this.controlGroup.getOutput$().pipe((0, _rxjs.map)(output => {
    var _output$dataViewIds;
    return (_output$dataViewIds = output.dataViewIds) !== null && _output$dataViewIds !== void 0 ? _output$dataViewIds : [];
  }), (0, _rxjs.switchMap)(dataViewIds => new Promise(resolve => Promise.all(dataViewIds.map(id => dataViews.get(id))).then(nextDataViews => resolve(nextDataViews))))) : (0, _rxjs.of)([]);
  const childDataViewsPipe = this.children$.pipe((0, _rxjs.switchMap)(children => {
    const childrenThatPublishDataViews = [];
    for (const child of Object.values(children)) {
      if ((0, _presentationPublishing.apiPublishesDataViews)(child)) childrenThatPublishDataViews.push(child);
    }
    if (childrenThatPublishDataViews.length === 0) return (0, _rxjs.of)([]);
    return (0, _rxjs.combineLatest)(childrenThatPublishDataViews.map(child => child.dataViews));
  }), (0, _rxjs.map)(nextDataViews => nextDataViews.flat().filter(dataView => Boolean(dataView))));
  return (0, _rxjs.combineLatest)([controlGroupDataViewsPipe, childDataViewsPipe]).pipe((0, _rxjs.switchMap)(([controlGroupDataViews, childDataViews]) => {
    const allDataViews = controlGroupDataViews.concat(childDataViews);
    if (allDataViews.length === 0) {
      return (async () => {
        const defaultDataViewId = await dataViews.getDefaultId();
        return [await dataViews.get(defaultDataViewId)];
      })();
    }
    return (0, _rxjs.of)((0, _lodash.uniqBy)(allDataViews, 'id'));
  })).subscribe(newDataViews => {
    var _this$controlGroup;
    if (newDataViews[0].id) (_this$controlGroup = this.controlGroup) === null || _this$controlGroup === void 0 ? void 0 : _this$controlGroup.setRelevantDataViewId(newDataViews[0].id);
    this.setAllDataViews(newDataViews);
  });
}