"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runClone = runClone;
exports.runQuickSave = runQuickSave;
exports.runSaveAs = runSaveAs;
var _ebtTools = require("@kbn/ebt-tools");
var _public = require("@kbn/embeddable-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _public2 = require("@kbn/saved-objects-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _dashboard_container_references = require("../../../../common/dashboard_container/persistable_state/dashboard_container_references");
var _dashboard_constants = require("../../../dashboard_constants");
var _plugin_services = require("../../../services/plugin_services");
var _extract_title_and_count = require("./lib/extract_title_and_count");
var _save_modal = require("./overlays/save_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const serializeAllPanelState = async dashboard => {
  const references = [];
  const panels = (0, _lodash.cloneDeep)(dashboard.getInput().panels);
  for (const [uuid, panel] of Object.entries(panels)) {
    if (!(0, _public.reactEmbeddableRegistryHasKey)(panel.type)) continue;
    const api = dashboard.children$.value[uuid];
    if (api && (0, _presentationContainers.apiHasSerializableState)(api)) {
      var _serializedState$refe;
      const serializedState = api.serializeState();
      panels[uuid].explicitInput = {
        ...serializedState.rawState,
        id: uuid
      };
      references.push(...(0, _dashboard_container_references.prefixReferencesFromPanel)(uuid, (_serializedState$refe = serializedState.references) !== null && _serializedState$refe !== void 0 ? _serializedState$refe : []));
    }
  }
  return {
    panels,
    references
  };
};
function runSaveAs() {
  const {
    data: {
      query: {
        timefilter: {
          timefilter
        }
      }
    },
    savedObjectsTagging: {
      hasApi: hasSavedObjectsTagging
    },
    dashboardContentManagement: {
      checkForDuplicateDashboardTitle,
      saveDashboardState
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    explicitInput: currentState,
    componentState: {
      lastSavedId,
      managed
    }
  } = this.getState();
  return new Promise(resolve => {
    var _currentState$descrip;
    if (managed) resolve(undefined);
    const onSave = async ({
      newTags,
      newTitle,
      newDescription,
      newCopyOnSave,
      newTimeRestore,
      onTitleDuplicate,
      isTitleDuplicateConfirmed
    }) => {
      var _saveResult$reference;
      const saveOptions = {
        confirmOverwrite: false,
        isTitleDuplicateConfirmed,
        onTitleDuplicate,
        saveAsCopy: newCopyOnSave
      };
      const stateFromSaveModal = {
        title: newTitle,
        tags: [],
        description: newDescription,
        timeRestore: newTimeRestore,
        timeRange: newTimeRestore ? timefilter.getTime() : undefined,
        refreshInterval: newTimeRestore ? timefilter.getRefreshInterval() : undefined
      };
      if (hasSavedObjectsTagging && newTags) {
        // remove `hasSavedObjectsTagging` once the savedObjectsTagging service is optional
        stateFromSaveModal.tags = newTags;
      }
      if (!(await checkForDuplicateDashboardTitle({
        title: newTitle,
        onTitleDuplicate,
        lastSavedTitle: currentState.title,
        copyOnSave: newCopyOnSave,
        isTitleDuplicateConfirmed
      }))) {
        // do not save if title is duplicate and is unconfirmed
        return {};
      }
      const {
        panels: nextPanels,
        references
      } = await serializeAllPanelState(this);
      const dashboardStateToSave = {
        ...currentState,
        panels: nextPanels,
        ...stateFromSaveModal
      };
      let stateToSave = dashboardStateToSave;
      let persistableControlGroupInput;
      if (this.controlGroup) {
        persistableControlGroupInput = this.controlGroup.getPersistableInput();
        stateToSave = {
          ...stateToSave,
          controlGroupInput: persistableControlGroupInput
        };
      }
      const beforeAddTime = window.performance.now();
      const saveResult = await saveDashboardState({
        panelReferences: references,
        currentState: stateToSave,
        saveOptions,
        lastSavedId
      });
      const addDuration = window.performance.now() - beforeAddTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_plugin_services.pluginServices.getServices().analytics, {
        eventName: _dashboard_constants.SAVED_OBJECT_POST_TIME,
        duration: addDuration,
        meta: {
          saved_object_type: _dashboard_constants.DASHBOARD_CONTENT_ID
        }
      });
      stateFromSaveModal.lastSavedId = saveResult.id;
      if (saveResult.id) {
        (0, _reactRedux.batch)(() => {
          this.dispatch.setStateFromSaveModal(stateFromSaveModal);
          this.dispatch.setLastSavedInput(dashboardStateToSave);
          if (this.controlGroup && persistableControlGroupInput) {
            this.controlGroup.setSavedState(persistableControlGroupInput);
          }
        });
      }
      this.savedObjectReferences = (_saveResult$reference = saveResult.references) !== null && _saveResult$reference !== void 0 ? _saveResult$reference : [];
      this.lastSavedState.next();
      resolve(saveResult);
      return saveResult;
    };
    const dashboardSaveModal = /*#__PURE__*/_react.default.createElement(_save_modal.DashboardSaveModal, {
      tags: currentState.tags,
      title: currentState.title,
      onClose: () => resolve(undefined),
      timeRestore: currentState.timeRestore,
      description: (_currentState$descrip = currentState.description) !== null && _currentState$descrip !== void 0 ? _currentState$descrip : '',
      showCopyOnSave: lastSavedId ? true : false,
      onSave: onSave
    });
    this.clearOverlays();
    (0, _public2.showSaveModal)(dashboardSaveModal);
  });
}

/**
 * Save the current state of this dashboard to a saved object without showing any save modal.
 */
async function runQuickSave() {
  var _saveResult$reference2;
  const {
    dashboardContentManagement: {
      saveDashboardState
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    explicitInput: currentState,
    componentState: {
      lastSavedId,
      managed
    }
  } = this.getState();
  if (managed) return;
  const {
    panels: nextPanels,
    references
  } = await serializeAllPanelState(this);
  const dashboardStateToSave = {
    ...currentState,
    panels: nextPanels
  };
  let stateToSave = dashboardStateToSave;
  let persistableControlGroupInput;
  if (this.controlGroup) {
    persistableControlGroupInput = this.controlGroup.getPersistableInput();
    stateToSave = {
      ...stateToSave,
      controlGroupInput: persistableControlGroupInput
    };
  }
  const saveResult = await saveDashboardState({
    panelReferences: references,
    currentState: stateToSave,
    saveOptions: {},
    lastSavedId
  });
  this.savedObjectReferences = (_saveResult$reference2 = saveResult.references) !== null && _saveResult$reference2 !== void 0 ? _saveResult$reference2 : [];
  this.dispatch.setLastSavedInput(dashboardStateToSave);
  this.lastSavedState.next();
  if (this.controlGroup && persistableControlGroupInput) {
    this.controlGroup.setSavedState(persistableControlGroupInput);
  }
  return saveResult;
}
async function runClone() {
  const {
    dashboardContentManagement: {
      saveDashboardState,
      checkForDuplicateDashboardTitle
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    explicitInput: currentState
  } = this.getState();
  return new Promise(async (resolve, reject) => {
    try {
      var _saveResult$reference3;
      const [baseTitle, baseCount] = (0, _extract_title_and_count.extractTitleAndCount)(currentState.title);
      let copyCount = baseCount;
      let newTitle = `${baseTitle} (${copyCount})`;
      while (!(await checkForDuplicateDashboardTitle({
        title: newTitle,
        lastSavedTitle: currentState.title,
        copyOnSave: true,
        isTitleDuplicateConfirmed: false
      }))) {
        copyCount++;
        newTitle = `${baseTitle} (${copyCount})`;
      }
      let stateToSave = currentState;
      if (this.controlGroup) {
        stateToSave = {
          ...stateToSave,
          controlGroupInput: this.controlGroup.getPersistableInput()
        };
      }
      const isManaged = this.getState().componentState.managed;
      const newPanels = await (async () => {
        if (!isManaged) return currentState.panels;

        // this is a managed dashboard - unlink all by reference embeddables on clone
        const unlinkedPanels = {};
        for (const [panelId, panel] of Object.entries(currentState.panels)) {
          const child = this.getChild(panelId);
          if (child && (0, _public.isReferenceOrValueEmbeddable)(child) && child.inputIsRefType(child.getInput())) {
            const valueTypeInput = await child.getInputAsValueType();
            unlinkedPanels[panelId] = {
              ...panel,
              explicitInput: valueTypeInput
            };
            continue;
          }
          unlinkedPanels[panelId] = panel;
        }
        return unlinkedPanels;
      })();
      const saveResult = await saveDashboardState({
        saveOptions: {
          saveAsCopy: true
        },
        currentState: {
          ...stateToSave,
          panels: newPanels,
          title: newTitle
        }
      });
      this.savedObjectReferences = (_saveResult$reference3 = saveResult.references) !== null && _saveResult$reference3 !== void 0 ? _saveResult$reference3 : [];
      resolve(saveResult);
      return saveResult.id ? {
        id: saveResult.id
      } : {
        error: saveResult.error
      };
    } catch (error) {
      reject(error);
    }
  });
}