"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mergeGroupedItemsProvider = exports.getEmbeddableFactoryMenuItemProvider = exports.EditorMenu = void 0;
require("./editor_menu.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _public = require("@kbn/visualizations-plugin/public");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_constants = require("../../dashboard_constants");
var _triggers = require("../../triggers");
var _add_panel_action_menu_items = require("./add_panel_action_menu_items");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getEmbeddableFactoryMenuItemProvider = (api, closePopover) => factory => {
  const icon = factory !== null && factory !== void 0 && factory.getIconType ? factory.getIconType() : 'empty';
  const toolTipContent = factory !== null && factory !== void 0 && factory.getDescription ? factory.getDescription() : undefined;
  return {
    name: factory.getDisplayName(),
    icon,
    toolTipContent,
    onClick: async () => {
      closePopover();
      api.addNewPanel({
        panelType: factory.type
      }, true);
    },
    'data-test-subj': `createNew-${factory.type}`
  };
};
exports.getEmbeddableFactoryMenuItemProvider = getEmbeddableFactoryMenuItemProvider;
const mergeGroupedItemsProvider = getEmbeddableFactoryMenuItem => (factoryGroupMap, groupedAddPanelAction) => {
  const initialPanelGroups = [];
  const additionalPanels = [];
  new Set(Object.keys(factoryGroupMap).concat(Object.keys(groupedAddPanelAction))).forEach(groupId => {
    const dataTestSubj = `dashboardEditorMenu-${groupId}Group`;
    const factoryGroup = factoryGroupMap[groupId];
    const addPanelGroup = groupedAddPanelAction[groupId];
    if (factoryGroup && addPanelGroup) {
      var _addPanelGroup$items;
      const panelId = factoryGroup.panelId;
      initialPanelGroups.push({
        'data-test-subj': dataTestSubj,
        name: factoryGroup.appName,
        icon: factoryGroup.icon,
        panel: panelId
      });
      additionalPanels.push({
        id: panelId,
        title: factoryGroup.appName,
        items: [...factoryGroup.factories.map(getEmbeddableFactoryMenuItem), ...((_addPanelGroup$items = addPanelGroup === null || addPanelGroup === void 0 ? void 0 : addPanelGroup.items) !== null && _addPanelGroup$items !== void 0 ? _addPanelGroup$items : [])]
      });
    } else if (factoryGroup) {
      const panelId = factoryGroup.panelId;
      initialPanelGroups.push({
        'data-test-subj': dataTestSubj,
        name: factoryGroup.appName,
        icon: factoryGroup.icon,
        panel: panelId
      });
      additionalPanels.push({
        id: panelId,
        title: factoryGroup.appName,
        items: factoryGroup.factories.map(getEmbeddableFactoryMenuItem)
      });
    } else if (addPanelGroup) {
      const panelId = addPanelGroup.id;
      initialPanelGroups.push({
        'data-test-subj': dataTestSubj,
        name: addPanelGroup.title,
        icon: addPanelGroup.icon,
        panel: panelId
      });
      additionalPanels.push({
        id: panelId,
        title: addPanelGroup.title,
        items: addPanelGroup.items
      });
    }
  });
  return [initialPanelGroups, additionalPanels];
};
exports.mergeGroupedItemsProvider = mergeGroupedItemsProvider;
const EditorMenu = ({
  createNewVisType,
  isDisabled,
  api
}) => {
  const isMounted = (0, _react.useRef)(false);
  const {
    embeddable,
    visualizations: {
      getAliases: getVisTypeAliases,
      getByGroup: getVisTypesByGroup,
      showNewVisModal
    },
    uiActions
  } = _plugin_services.pluginServices.getServices();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const embeddableFactories = (0, _react.useMemo)(() => Array.from(embeddable.getEmbeddableFactories()), [embeddable]);
  const [unwrappedEmbeddableFactories, setUnwrappedEmbeddableFactories] = (0, _react.useState)([]);
  const [addPanelActions, setAddPanelActions] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    Promise.all(embeddableFactories.map(async factory => ({
      factory,
      isEditable: await factory.isEditable()
    }))).then(factories => {
      setUnwrappedEmbeddableFactories(factories);
    });
  }, [embeddableFactories]);
  const createNewAggsBasedVis = (0, _react.useCallback)(visType => () => showNewVisModal({
    originatingApp: _dashboard_constants.DASHBOARD_APP_ID,
    outsideVisualizeApp: true,
    showAggsSelection: true,
    selectedVisType: visType
  }), [showNewVisModal]);
  const getSortedVisTypesByGroup = group => getVisTypesByGroup(group).sort((a, b) => {
    const labelA = 'titleInWizard' in a ? a.titleInWizard || a.title : a.title;
    const labelB = 'titleInWizard' in b ? b.titleInWizard || a.title : a.title;
    if (labelA < labelB) {
      return -1;
    }
    if (labelA > labelB) {
      return 1;
    }
    return 0;
  }).filter(({
    disableCreate
  }) => !disableCreate);
  const promotedVisTypes = getSortedVisTypesByGroup(_public.VisGroups.PROMOTED);
  const aggsBasedVisTypes = getSortedVisTypesByGroup(_public.VisGroups.AGGBASED);
  const toolVisTypes = getSortedVisTypesByGroup(_public.VisGroups.TOOLS);
  const visTypeAliases = getVisTypeAliases().sort(({
    promotion: a = false
  }, {
    promotion: b = false
  }) => a === b ? 0 : a ? -1 : 1).filter(({
    disableCreate
  }) => !disableCreate);
  const factories = unwrappedEmbeddableFactories.filter(({
    isEditable,
    factory: {
      type,
      canCreateNew,
      isContainerType
    }
  }) => isEditable && !isContainerType && canCreateNew() && type !== 'visualization');
  const factoryGroupMap = {};
  const ungroupedFactories = [];
  const aggBasedPanelID = 1;
  let panelCount = 1 + aggBasedPanelID;
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);

  // Retrieve ADD_PANEL_TRIGGER actions
  (0, _react.useEffect)(() => {
    async function loadPanelActions() {
      var _uiActions$getTrigger;
      const registeredActions = await (uiActions === null || uiActions === void 0 ? void 0 : (_uiActions$getTrigger = uiActions.getTriggerCompatibleActions) === null || _uiActions$getTrigger === void 0 ? void 0 : _uiActions$getTrigger.call(uiActions, _triggers.ADD_PANEL_TRIGGER, {
        embeddable: api
      }));
      if (isMounted.current) {
        setAddPanelActions(registeredActions);
      }
    }
    loadPanelActions();
  }, [uiActions, api]);
  factories.forEach(({
    factory
  }) => {
    const {
      grouping
    } = factory;
    if (grouping) {
      grouping.forEach(group => {
        if (factoryGroupMap[group.id]) {
          factoryGroupMap[group.id].factories.push(factory);
        } else {
          factoryGroupMap[group.id] = {
            id: group.id,
            appName: group.getDisplayName ? group.getDisplayName({
              embeddable
            }) : group.id,
            icon: group.getIconType ? group.getIconType({
              embeddable
            }) : 'empty',
            factories: [factory],
            panelId: panelCount
          };
          panelCount++;
        }
      });
    } else {
      ungroupedFactories.push(factory);
    }
  });
  const getVisTypeMenuItem = visType => {
    const {
      name,
      title,
      titleInWizard,
      description,
      icon = 'empty',
      group,
      isDeprecated
    } = visType;
    return {
      name: !isDeprecated ? titleInWizard || title : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        responsive: false,
        gutterSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, titleInWizard || title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "warning"
      }, _i18n.i18n.translate('dashboard.editorMenu.deprecatedTag', {
        defaultMessage: 'Deprecated'
      })))),
      icon: icon,
      onClick:
      // not all the agg-based visualizations need to be created via the wizard
      group === _public.VisGroups.AGGBASED && visType.options.showIndexSelection ? createNewAggsBasedVis(visType) : createNewVisType(visType),
      'data-test-subj': `visType-${name}`,
      toolTipContent: description
    };
  };
  const getVisTypeAliasMenuItem = visTypeAlias => {
    const {
      name,
      title,
      description,
      icon = 'empty'
    } = visTypeAlias;
    return {
      name: title,
      icon,
      onClick: createNewVisType(visTypeAlias),
      'data-test-subj': `visType-${name}`,
      toolTipContent: description
    };
  };
  const aggsPanelTitle = _i18n.i18n.translate('dashboard.editorMenu.aggBasedGroupTitle', {
    defaultMessage: 'Aggregation based'
  });
  const getEditorMenuPanels = closePopover => {
    const getEmbeddableFactoryMenuItem = getEmbeddableFactoryMenuItemProvider(api, closePopover);
    const [ungroupedAddPanelActions, groupedAddPanelAction] = (0, _add_panel_action_menu_items.getAddPanelActionMenuItems)(api, addPanelActions, closePopover);
    const [initialPanelGroups, additionalPanels] = mergeGroupedItemsProvider(getEmbeddableFactoryMenuItem)(factoryGroupMap, groupedAddPanelAction);
    const initialPanelItems = [...visTypeAliases.map(getVisTypeAliasMenuItem), ...ungroupedAddPanelActions, ...toolVisTypes.map(getVisTypeMenuItem), ...ungroupedFactories.map(getEmbeddableFactoryMenuItem), ...initialPanelGroups, ...promotedVisTypes.map(getVisTypeMenuItem)];
    if (aggsBasedVisTypes.length > 0) {
      initialPanelItems.push({
        name: aggsPanelTitle,
        icon: 'visualizeApp',
        panel: aggBasedPanelID,
        'data-test-subj': `dashboardEditorAggBasedMenuItem`
      });
    }
    return [{
      id: 0,
      items: initialPanelItems
    }, {
      id: aggBasedPanelID,
      title: aggsPanelTitle,
      items: aggsBasedVisTypes.map(getVisTypeMenuItem)
    }, ...additionalPanels];
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarPopover, {
    zIndex: Number(euiTheme.levels.header) - 1,
    repositionOnScroll: true,
    ownFocus: true,
    label: _i18n.i18n.translate('dashboard.solutionToolbar.editorMenuButtonLabel', {
      defaultMessage: 'Add panel'
    }),
    isDisabled: isDisabled,
    size: "s",
    iconType: "plusInCircle",
    panelPaddingSize: "none",
    "data-test-subj": "dashboardEditorMenuButton"
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: getEditorMenuPanels(closePopover),
    className: `dshSolutionToolbar__editorContextMenu`,
    "data-test-subj": "dashboardEditorContextMenu"
  }));
};
exports.EditorMenu = EditorMenu;