"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardEditingToolbar = DashboardEditingToolbar;
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _dashboard_app_strings = require("../_dashboard_app_strings");
var _editor_menu = require("./editor_menu");
var _dashboard_app = require("../dashboard_app");
var _plugin_services = require("../../services/plugin_services");
var _controls_toolbar_button = require("./controls_toolbar_button");
var _dashboard_constants = require("../../dashboard_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DashboardEditingToolbar({
  isDisabled
}) {
  var _usageCollection$repo;
  const {
    usageCollection,
    data: {
      search
    },
    embeddable: {
      getStateTransfer
    },
    visualizations: {
      getAliases: getVisTypeAliases
    }
  } = _plugin_services.pluginServices.getServices();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dashboard = (0, _dashboard_app.useDashboardAPI)();
  const stateTransferService = getStateTransfer();
  const lensAlias = getVisTypeAliases().find(({
    name
  }) => name === 'lens');
  const trackUiMetric = (_usageCollection$repo = usageCollection.reportUiCounter) === null || _usageCollection$repo === void 0 ? void 0 : _usageCollection$repo.bind(usageCollection, _dashboard_constants.DASHBOARD_UI_METRIC_ID);
  const createNewVisType = (0, _react2.useCallback)(visType => () => {
    var _dashboard$getAppCont, _dashboard$getAppCont2, _dashboard$getAppCont3;
    let path = '';
    let appId = '';
    if (visType) {
      if (trackUiMetric) {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, `${visType.name}:create`);
      }
      if (!('alias' in visType)) {
        // this visualization is not an alias
        appId = 'visualize';
        path = `#/create?type=${encodeURIComponent(visType.name)}`;
      } else if (visType.alias && 'path' in visType.alias) {
        // this visualization **is** an alias, and it has an app to redirect to for creation
        appId = visType.alias.app;
        path = visType.alias.path;
      }
    } else {
      appId = 'visualize';
      path = '#/create?';
    }
    stateTransferService.navigateToEditor(appId, {
      path,
      state: {
        originatingApp: (_dashboard$getAppCont = dashboard.getAppContext()) === null || _dashboard$getAppCont === void 0 ? void 0 : _dashboard$getAppCont.currentAppId,
        originatingPath: (_dashboard$getAppCont2 = dashboard.getAppContext()) === null || _dashboard$getAppCont2 === void 0 ? void 0 : (_dashboard$getAppCont3 = _dashboard$getAppCont2.getCurrentPath) === null || _dashboard$getAppCont3 === void 0 ? void 0 : _dashboard$getAppCont3.call(_dashboard$getAppCont2),
        searchSessionId: search.session.getSessionId()
      }
    });
  }, [stateTransferService, dashboard, search.session, trackUiMetric]);

  /**
   * embeddableFactory: Required, you can get the factory from embeddableStart.getEmbeddableFactory(<embeddable type, i.e. lens>)
   * initialInput: Optional, use it in case you want to pass your own input to the factory
   * dismissNotification: Optional, if not passed a toast will appear in the dashboard
   */

  const extraButtons = [/*#__PURE__*/_react2.default.createElement(_editor_menu.EditorMenu, {
    createNewVisType: createNewVisType,
    isDisabled: isDisabled,
    api: dashboard
  }), /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.AddFromLibraryButton, {
    onClick: () => dashboard.addFromLibrary(),
    size: "s",
    "data-test-subj": "dashboardAddFromLibraryButton",
    isDisabled: isDisabled
  })];
  if (dashboard.controlGroup) {
    extraButtons.push( /*#__PURE__*/_react2.default.createElement(_controls_toolbar_button.ControlsToolbarButton, {
      isDisabled: isDisabled,
      controlGroup: dashboard.controlGroup
    }));
  }
  return /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
        padding: 0 ${euiTheme.size.s} ${euiTheme.size.s} ${euiTheme.size.s};
      `
  }, /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.Toolbar, null, {
    primaryButton: /*#__PURE__*/_react2.default.createElement(_sharedUxButtonToolbar.ToolbarButton, {
      type: "primary",
      isDisabled: isDisabled,
      iconType: "lensApp",
      size: "s",
      onClick: createNewVisType(lensAlias),
      label: (0, _dashboard_app_strings.getCreateVisualizationButtonTitle)(),
      "data-test-subj": "dashboardAddNewPanelButton"
    }),
    extraButtons
  }));
}