"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAddPanelActionMenuItems = void 0;
var _triggers = require("../../triggers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const onAddPanelActionClick = (action, context, closePopover) => event => {
  closePopover();
  if (event.currentTarget instanceof HTMLAnchorElement) {
    if (!event.defaultPrevented &&
    // onClick prevented default
    event.button === 0 && (!event.currentTarget.target || event.currentTarget.target === '_self') && !(event.metaKey || event.altKey || event.ctrlKey || event.shiftKey)) {
      event.preventDefault();
      action.execute(context);
    }
  } else action.execute(context);
};
const getAddPanelActionMenuItems = (api, actions, closePopover) => {
  const ungrouped = [];
  const grouped = {};
  const context = {
    embeddable: api,
    trigger: _triggers.addPanelMenuTrigger
  };
  const getMenuItem = item => {
    var _ref, _item$getDisplayNameT;
    const actionName = item.getDisplayName(context);
    return {
      name: actionName,
      icon: (_ref = typeof item.getIconType === 'function' ? item.getIconType(context) : undefined) !== null && _ref !== void 0 ? _ref : 'empty',
      onClick: onAddPanelActionClick(item, context, closePopover),
      'data-test-subj': `create-action-${actionName}`,
      toolTipContent: item === null || item === void 0 ? void 0 : (_item$getDisplayNameT = item.getDisplayNameTooltip) === null || _item$getDisplayNameT === void 0 ? void 0 : _item$getDisplayNameT.call(item, context)
    };
  };
  actions === null || actions === void 0 ? void 0 : actions.forEach(item => {
    if (Array.isArray(item.grouping)) {
      item.grouping.forEach(group => {
        if (!grouped[group.id]) {
          var _ref2;
          grouped[group.id] = {
            id: group.id,
            icon: (_ref2 = typeof group.getIconType === 'function' ? group.getIconType(context) : undefined) !== null && _ref2 !== void 0 ? _ref2 : 'empty',
            title: group.getDisplayName ? group.getDisplayName(context) : undefined,
            items: []
          };
        }
        grouped[group.id].items.push(getMenuItem(item));
      });
    } else {
      ungrouped.push(getMenuItem(item));
    }
  });
  return [ungrouped, grouped];
};
exports.getAddPanelActionMenuItems = getAddPanelActionMenuItems;