"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDashboardAppInNoDataState = exports.DashboardAppNoDataPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _plugin_services = require("../../services/plugin_services");
var _dashboard_constants = require("../../dashboard_constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
const DashboardAppNoDataPage = ({
  onDataViewCreated
}) => {
  const {
    application,
    data: {
      dataViews
    },
    dataViewEditor,
    http: {
      basePath,
      get
    },
    documentationLinks: {
      indexPatternsDocLink,
      kibanaGuideDocLink,
      esqlDocLink
    },
    customBranding,
    noDataPage,
    share
  } = _plugin_services.pluginServices.getServices();
  const analyticsServices = {
    coreStart: {
      docLinks: {
        links: {
          kibana: {
            guide: kibanaGuideDocLink
          },
          indexPatterns: {
            introduction: indexPatternsDocLink
          },
          query: {
            queryESQL: esqlDocLink
          }
        }
      },
      application,
      http: {
        basePath,
        get
      },
      customBranding: {
        hasCustomBranding$: customBranding.hasCustomBranding$
      }
    },
    dataViews,
    dataViewEditor,
    noDataPage,
    share: share.url ? {
      url: share.url
    } : undefined
  };
  const importPromise = Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/shared-ux-page-analytics-no-data')));
  const AnalyticsNoDataPageKibanaProvider = (0, _sharedUxUtility.withSuspense)( /*#__PURE__*/_react.default.lazy(() => importPromise.then(({
    AnalyticsNoDataPageKibanaProvider: NoDataProvider
  }) => {
    return {
      default: NoDataProvider
    };
  })));
  const AnalyticsNoDataPage = (0, _sharedUxUtility.withSuspense)( /*#__PURE__*/_react.default.lazy(() => importPromise.then(({
    AnalyticsNoDataPage: NoDataPage
  }) => {
    return {
      default: NoDataPage
    };
  })));
  return /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPageKibanaProvider, analyticsServices, /*#__PURE__*/_react.default.createElement(AnalyticsNoDataPage, {
    onDataViewCreated: onDataViewCreated
  }));
};
exports.DashboardAppNoDataPage = DashboardAppNoDataPage;
const isDashboardAppInNoDataState = async () => {
  const {
    data: {
      dataViews
    },
    embeddable,
    dashboardContentManagement,
    dashboardBackup
  } = _plugin_services.pluginServices.getServices();
  const hasUserDataView = await dataViews.hasData.hasUserDataView().catch(() => false);
  if (hasUserDataView) return false;

  // consider has data if there is an incoming embeddable
  const hasIncomingEmbeddable = embeddable.getStateTransfer().getIncomingEmbeddablePackage(_dashboard_constants.DASHBOARD_APP_ID, false);
  if (hasIncomingEmbeddable) return false;

  // consider has data if there is unsaved dashboard with edits
  if (dashboardBackup.dashboardHasUnsavedEdits()) return false;

  // consider has data if there is at least one dashboard
  const {
    total
  } = await dashboardContentManagement.findDashboards.search({
    search: '',
    size: 1
  }).catch(() => ({
    total: 0
  }));
  if (total > 0) return false;
  return true;
};
exports.isDashboardAppInNoDataState = isDashboardAppInNoDataState;