"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LibraryNotificationPopover = LibraryNotificationPopover;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function LibraryNotificationPopover({
  unlinkAction,
  api
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      iconType: 'folderCheck',
      onClick: () => setIsPopoverOpen(!isPopoverOpen),
      "data-test-subj": 'embeddablePanelNotification-ACTION_LIBRARY_NOTIFICATION',
      "aria-label": _dashboard_actions_strings.dashboardLibraryNotificationStrings.getPopoverAriaLabel()
    }),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    anchorPosition: "upCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, _dashboard_actions_strings.dashboardLibraryNotificationStrings.getDisplayName()), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _dashboard_actions_strings.dashboardLibraryNotificationStrings.getTooltip()))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": 'libraryNotificationUnlinkButton',
    size: "s",
    fill: true,
    onClick: () => unlinkAction.execute({
      embeddable: api
    })
  }, unlinkAction.getDisplayName({
    embeddable: api
  }))))));
}