"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LibraryNotificationAction = exports.ACTION_LIBRARY_NOTIFICATION = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _library_notification_popover = require("./library_notification_popover");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _unlink_from_library_action = require("./unlink_from_library_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_LIBRARY_NOTIFICATION = exports.ACTION_LIBRARY_NOTIFICATION = 'ACTION_LIBRARY_NOTIFICATION';
class LibraryNotificationAction {
  constructor(unlinkAction) {
    (0, _defineProperty2.default)(this, "id", ACTION_LIBRARY_NOTIFICATION);
    (0, _defineProperty2.default)(this, "type", ACTION_LIBRARY_NOTIFICATION);
    (0, _defineProperty2.default)(this, "order", 1);
    (0, _defineProperty2.default)(this, "MenuItem", ({
      context
    }) => {
      const {
        embeddable
      } = context;
      if (!(0, _unlink_from_library_action.isApiCompatible)(embeddable)) throw new _public.IncompatibleActionError();
      return /*#__PURE__*/_react.default.createElement(_library_notification_popover.LibraryNotificationPopover, {
        unlinkAction: this.unlinkAction,
        api: embeddable
      });
    });
    (0, _defineProperty2.default)(this, "isCompatible", async ({
      embeddable
    }) => {
      if (!(0, _unlink_from_library_action.isApiCompatible)(embeddable)) return false;
      return (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit' && embeddable.canUnlinkFromLibrary();
    });
    (0, _defineProperty2.default)(this, "execute", async () => {});
    this.unlinkAction = unlinkAction;
  }
  couldBecomeCompatible({
    embeddable
  }) {
    return (0, _unlink_from_library_action.isApiCompatible)(embeddable);
  }
  subscribeToCompatibilityChanges({
    embeddable
  }, onChange) {
    var _getViewModeSubject;
    if (!(0, _unlink_from_library_action.isApiCompatible)(embeddable)) return;

    /**
     * TODO: Upgrade this action by subscribing to changes in the existance of a saved object id. Currently,
     *  this is unnecessary because a link or unlink operation will cause the panel to unmount and remount.
     */
    return (_getViewModeSubject = (0, _presentationPublishing.getViewModeSubject)(embeddable)) === null || _getViewModeSubject === void 0 ? void 0 : _getViewModeSubject.subscribe(viewMode => {
      embeddable.canUnlinkFromLibrary().then(canUnlink => {
        onChange(viewMode === 'edit' && canUnlink, this);
      });
    });
  }
  getDisplayName({
    embeddable
  }) {
    if (!(0, _unlink_from_library_action.isApiCompatible)(embeddable)) throw new _public.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardLibraryNotificationStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!(0, _unlink_from_library_action.isApiCompatible)(embeddable)) throw new _public.IncompatibleActionError();
    return 'folderCheck';
  }
}
exports.LibraryNotificationAction = LibraryNotificationAction;