"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OPEN_FLYOUT_EDIT_DRILLDOWN = exports.FlyoutEditDrilldownAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public3 = require("@kbn/embeddable-plugin/public");
var _public4 = require("@kbn/embeddable-enhanced-plugin/public");
var _i18n = require("./i18n");
var _menu_item = require("./menu_item");
var _drilldown_shared = require("../drilldown_shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OPEN_FLYOUT_EDIT_DRILLDOWN = exports.OPEN_FLYOUT_EDIT_DRILLDOWN = 'OPEN_FLYOUT_EDIT_DRILLDOWN';
const isApiCompatible = api => (0, _public4.apiHasDynamicActions)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasSupportedTriggers)(api);
class FlyoutEditDrilldownAction {
  constructor(params) {
    (0, _defineProperty2.default)(this, "type", OPEN_FLYOUT_EDIT_DRILLDOWN);
    (0, _defineProperty2.default)(this, "id", OPEN_FLYOUT_EDIT_DRILLDOWN);
    (0, _defineProperty2.default)(this, "order", 10);
    (0, _defineProperty2.default)(this, "MenuItem", _menu_item.MenuItem);
    this.params = params;
  }
  getDisplayName() {
    return _i18n.txtDisplayName;
  }
  getIconType() {
    return 'list';
  }
  async isCompatible({
    embeddable
  }) {
    var _embeddable$dynamicAc, _embeddable$dynamicAc2;
    if (!isApiCompatible(embeddable) || (0, _presentationPublishing.getInheritedViewMode)(embeddable) !== 'edit') return false;
    return ((_embeddable$dynamicAc = (_embeddable$dynamicAc2 = embeddable.dynamicActionsState$.getValue()) === null || _embeddable$dynamicAc2 === void 0 ? void 0 : _embeddable$dynamicAc2.dynamicActions.events) !== null && _embeddable$dynamicAc !== void 0 ? _embeddable$dynamicAc : []).length > 0;
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    const {
      core,
      plugins
    } = this.params.start();
    const templates = (0, _drilldown_shared.createDrilldownTemplatesFromSiblings)(embeddable);
    const overlayTracker = (0, _presentationContainers.tracksOverlays)(embeddable.parentApi) ? embeddable.parentApi : undefined;
    const close = () => {
      if (overlayTracker) overlayTracker.clearOverlays();
      handle.close();
    };
    const handle = core.overlays.openFlyout((0, _public2.toMountPoint)( /*#__PURE__*/_react.default.createElement(plugins.uiActionsEnhanced.DrilldownManager, {
      initialRoute: '/manage',
      dynamicActionManager: embeddable.enhancements.dynamicActions,
      triggers: [...(0, _drilldown_shared.ensureNestedTriggers)(embeddable.supportedTriggers()), _public3.CONTEXT_MENU_TRIGGER],
      placeContext: {
        embeddable
      },
      templates: templates,
      onClose: close
    }), {
      theme$: core.theme.theme$
    }), {
      ownFocus: true,
      'data-test-subj': 'editDrilldownFlyout',
      onClose: () => {
        close();
      }
    });
    overlayTracker === null || overlayTracker === void 0 ? void 0 : overlayTracker.openOverlay(handle);
  }
}
exports.FlyoutEditDrilldownAction = FlyoutEditDrilldownAction;