"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findServiceFactory = void 0;
var _common = require("../../../common");
var _find = require("../find");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * A type definition for a factory to produce the `CustomIntegrationsFindService` for use in Kibana.
 */

/**
 * A factory to produce the `CustomIntegrationsFindService` for use in Kibana.
 */
const findServiceFactory = ({
  coreStart
}) => ({
  findAppendedIntegrations: async params => {
    const integrations = await coreStart.http.get(_common.ROUTES_APPEND_CUSTOM_INTEGRATIONS);
    return (0, _find.filterCustomIntegrations)(integrations, params);
  },
  findReplacementIntegrations: async params => {
    const replacements = await coreStart.http.get(_common.ROUTES_REPLACEMENT_CUSTOM_INTEGRATIONS);
    return (0, _find.filterCustomIntegrations)(replacements, params);
  }
});
exports.findServiceFactory = findServiceFactory;