"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndexAdd = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../services/breadcrumbs");
var _components = require("../../components");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FollowerIndexAdd extends _react.PureComponent {
  componentDidMount() {
    (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)('/follower_indices'), _breadcrumbs.addBreadcrumb]);
  }
  componentWillUnmount() {
    this.props.clearApiError();
  }
  render() {
    const {
      saveFollowerIndex,
      clearApiError,
      apiStatus,
      apiError,
      match: {
        url: currentUrl
      }
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_components.RemoteClustersProvider, null, ({
      isLoading,
      error,
      remoteClusters
    }) => {
      if (isLoading) {
        return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexCreateForm.loadingRemoteClustersMessage",
          defaultMessage: "Loading remote clusters\u2026"
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        restrictWidth: true,
        style: {
          width: '100%'
        }
      }, /*#__PURE__*/_react.default.createElement(_components.FollowerIndexPageTitle, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndex.addTitle",
          defaultMessage: "Add follower index"
        })
      }), /*#__PURE__*/_react.default.createElement(_components.FollowerIndexForm, {
        apiStatus: apiStatus,
        apiError: apiError,
        currentUrl: currentUrl,
        remoteClusters: error ? [] : remoteClusters,
        saveFollowerIndex: saveFollowerIndex,
        clearApiError: clearApiError,
        saveButtonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexCreateForm.saveButtonLabel",
          defaultMessage: "Create"
        })
      }));
    });
  }
}
exports.FollowerIndexAdd = FollowerIndexAdd;
(0, _defineProperty2.default)(FollowerIndexAdd, "propTypes", {
  saveFollowerIndex: _propTypes.default.func.isRequired,
  clearApiError: _propTypes.default.func.isRequired,
  apiError: _propTypes.default.object,
  apiStatus: _propTypes.default.string.isRequired
});