"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RemoteClustersFormField = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _routing = require("../services/routing");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const errorMessages = {
  noClusterFound: () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.crossClusterReplication.remoteClustersFormField.emptyRemoteClustersCallOutDescription",
    defaultMessage: "You need at least one remote cluster to create a follower index."
  }),
  remoteClusterNotConnectedEditable: name => ({
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.remoteClustersFormField.currentRemoteClusterNotConnectedCallOutTitle",
      defaultMessage: "Remote cluster '{name}' is not connected",
      values: {
        name
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.remoteClustersFormField.currentRemoteClusterNotConnectedCallOutDescription",
      defaultMessage: "Edit the remote cluster or select a cluster that is connected."
    })
  })
};
class RemoteClustersFormField extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "errorMessages", {
      ...errorMessages,
      ...this.props.errorMessages
    });
    (0, _defineProperty2.default)(this, "onRemoteClusterChange", cluster => {
      const {
        onChange,
        onError
      } = this.props;
      const {
        error
      } = this.validateRemoteCluster(cluster);
      onChange(cluster);
      onError(error);
    });
    (0, _defineProperty2.default)(this, "renderNotEditable", () => {
      const {
        areErrorsVisible
      } = this.props;
      const errorMessage = this.renderErrorMessage();
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        value: this.props.selected,
        fullWidth: true,
        disabled: true,
        isInvalid: areErrorsVisible && Boolean(errorMessage),
        "data-test-subj": "remoteClusterInput"
      }), areErrorsVisible && Boolean(errorMessage) ? this.renderValidRemoteClusterRequired() : null, errorMessage);
    });
    (0, _defineProperty2.default)(this, "renderValidRemoteClusterRequired", () => /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.crossClusterReplication.remoteClustersFormField.validRemoteClusterRequired",
      defaultMessage: "A connected remote cluster is required."
    })));
    (0, _defineProperty2.default)(this, "renderDropdown", () => {
      const {
        remoteClusters,
        selected,
        currentUrl,
        areErrorsVisible
      } = this.props;
      const hasClusters = Boolean(remoteClusters.length);
      const remoteClustersOptions = hasClusters ? remoteClusters.map(({
        name,
        isConnected
      }) => ({
        value: name,
        text: isConnected ? name : _i18n.i18n.translate('xpack.crossClusterReplication.remoteClustersFormField.remoteClusterDropdownNotConnected', {
          defaultMessage: '{name} (not connected)',
          values: {
            name
          }
        }),
        'data-test-subj': `option-${name}`
      })) : [];
      const errorMessage = this.renderErrorMessage();
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
        fullWidth: true,
        options: remoteClustersOptions,
        value: hasClusters ? selected : '',
        onChange: e => {
          this.onRemoteClusterChange(e.target.value);
        },
        hasNoInitialSelection: !hasClusters,
        isInvalid: areErrorsVisible && Boolean(errorMessage),
        "data-test-subj": "remoteClusterSelect",
        "aria-label": _i18n.i18n.translate('xpack.crossClusterReplication.remoteClustersFormField.remoteClusterSelectAriaLabel', {
          defaultMessage: 'Remote cluster selection'
        })
      }), areErrorsVisible && Boolean(errorMessage) ? this.renderValidRemoteClusterRequired() : null, errorMessage, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement("div", null, ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: _routing.routing.getHrefToRemoteClusters('/add', {
          redirect: `/data/cross_cluster_replication${currentUrl}`
        }, true),
        size: "s",
        iconType: "plusInCircle",
        flush: "left",
        "data-test-subj": "addButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.remoteClustersFormField.addRemoteClusterButtonLabel",
        defaultMessage: "Add remote cluster"
      }))));
    });
    (0, _defineProperty2.default)(this, "renderNoClusterFound", () => {
      const {
        currentUrl
      } = this.props;
      const title = _i18n.i18n.translate('xpack.crossClusterReplication.remoteClustersFormField.emptyRemoteClustersCallOutTitle', {
        defaultMessage: `You don't have any remote clusters`
      });
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: title,
        color: "danger",
        iconType: "cross",
        "data-test-subj": "noClusterFoundError"
      }, /*#__PURE__*/_react.default.createElement("p", null, this.errorMessages.noClusterFound()), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        href: _routing.routing.getHrefToRemoteClusters('/add', {
          redirect: `/data/cross_cluster_replication${currentUrl}`
        }, true),
        iconType: "plusInCircle",
        color: "danger",
        "data-test-subj": "addButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.remoteClustersFormField.addRemoteClusterButtonLabel",
        defaultMessage: "Add remote cluster"
      }))));
    });
    (0, _defineProperty2.default)(this, "renderCurrentRemoteClusterNotConnected", (name, fatal) => {
      const {
        isEditable,
        currentUrl
      } = this.props;
      const {
        remoteClusterNotConnectedEditable,
        remoteClusterNotConnectedNotEditable
      } = this.errorMessages;
      const {
        title,
        description
      } = isEditable ? remoteClusterNotConnectedEditable(name) : remoteClusterNotConnectedNotEditable(name);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: title,
        color: fatal ? 'danger' : 'warning',
        iconType: "cross",
        "data-test-subj": "notConnectedError"
      }, /*#__PURE__*/_react.default.createElement("p", null, description), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        href: _routing.routing.getHrefToRemoteClusters(`/edit/${name}`, {
          redirect: `/data/cross_cluster_replication${currentUrl}`
        }, true),
        color: fatal ? 'danger' : 'warning',
        "data-test-subj": "editButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.remoteClustersFormField.viewRemoteClusterButtonLabel",
        defaultMessage: "Edit remote cluster"
      })));
    });
    (0, _defineProperty2.default)(this, "renderRemoteClusterDoesNotExist", name => {
      const {
        currentUrl
      } = this.props;
      const title = _i18n.i18n.translate('xpack.crossClusterReplication.remoteClustersFormField.remoteClusterNotFoundTitle', {
        defaultMessage: `Couldn't find remote cluster '{name}'`,
        values: {
          name
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: title,
        color: "danger",
        iconType: "cross"
      }, /*#__PURE__*/_react.default.createElement("p", null, this.errorMessages.remoteClusterDoesNotExist(name)), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        href: _routing.routing.getHrefToRemoteClusters(`/add`, {
          redirect: `/data/cross_cluster_replication${currentUrl}`
        }, true),
        iconType: "plusInCircle",
        color: "danger",
        "data-test-subj": "addButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.remoteClustersFormField.addRemoteClusterButtonLabel",
        defaultMessage: "Add remote cluster"
      })));
    });
    (0, _defineProperty2.default)(this, "renderErrorMessage", () => {
      const {
        selected,
        remoteClusters,
        isEditable
      } = this.props;
      const remoteCluster = remoteClusters.find(c => c.name === selected);
      const isSelectedRemoteClusterConnected = remoteCluster && remoteCluster.isConnected;
      let error;
      if (isEditable) {
        /* Create */
        const hasClusters = Boolean(remoteClusters.length);
        if (hasClusters && !isSelectedRemoteClusterConnected) {
          error = this.renderCurrentRemoteClusterNotConnected(selected);
        } else if (!hasClusters) {
          error = this.renderNoClusterFound();
        }
      } else {
        /* Edit */
        const doesExists = !!remoteCluster;
        if (!doesExists) {
          error = this.renderRemoteClusterDoesNotExist(selected);
        } else if (!isSelectedRemoteClusterConnected) {
          error = this.renderCurrentRemoteClusterNotConnected(selected, true);
        }
      }
      return error ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), error) : null;
    });
  }
  componentDidMount() {
    const {
      selected,
      onError
    } = this.props;
    const {
      error
    } = this.validateRemoteCluster(selected);
    onError(error);
  }
  validateRemoteCluster(clusterName) {
    const {
      remoteClusters
    } = this.props;
    const remoteCluster = remoteClusters.find(c => c.name === clusterName);
    return remoteCluster && remoteCluster.isConnected ? {
      error: null
    } : {
      error: {
        message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.remoteClustersFormField.invalidRemoteClusterError",
          defaultMessage: "Invalid remote cluster"
        })
      }
    };
  }
  render() {
    const {
      remoteClusters,
      selected,
      isEditable,
      areErrorsVisible
    } = this.props;
    const remoteCluster = remoteClusters.find(c => c.name === selected);
    const hasClusters = Boolean(remoteClusters.length);
    const isSelectedRemoteClusterConnected = remoteCluster && remoteCluster.isConnected;
    const isInvalid = areErrorsVisible && (!hasClusters || !isSelectedRemoteClusterConnected);
    let field;
    if (isEditable) {
      if (hasClusters) {
        field = this.renderDropdown();
      } else {
        field = this.renderErrorMessage();
      }
    } else {
      field = this.renderNotEditable();
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.remoteClustersFormField.fieldClusterLabel",
        defaultMessage: "Remote cluster"
      }),
      isInvalid: isInvalid,
      fullWidth: true,
      "data-test-subj": "remoteClusterFormField"
    }, field);
  }
}
exports.RemoteClustersFormField = RemoteClustersFormField;