"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerInternalGetRoute = registerInternalGetRoute;
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function registerInternalGetRoute(router) {
  const getFromRequest = async (uiSettingsClient, context, request, response) => {
    try {
      return response.ok({
        body: {
          settings: await uiSettingsClient.getUserProvided()
        }
      });
    } catch (error) {
      if (_coreSavedObjectsServer.SavedObjectsErrorHelpers.isSavedObjectsClientError(error)) {
        return response.customError({
          body: error,
          statusCode: error.output.statusCode
        });
      }
      throw error;
    }
  };
  router.get({
    path: '/internal/kibana/settings',
    validate: false,
    options: {
      access: 'internal'
    }
  }, async (context, request, response) => {
    const uiSettingsClient = (await context.core).uiSettings.client;
    return await getFromRequest(uiSettingsClient, context, request, response);
  });
  router.get({
    path: '/internal/kibana/global_settings',
    validate: false,
    options: {
      access: 'internal'
    }
  }, async (context, request, response) => {
    const uiSettingsClient = (await context.core).uiSettings.globalClient;
    return await getFromRequest(uiSettingsClient, context, request, response);
  });
}