"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildIndexMeta = exports.buildIndexMappings = void 0;
var _lodash = require("lodash");
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _core = require("../../core");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Build the mappings to use when creating a new index.
 *
 * @param types The list of all registered SO types.
 */
const buildIndexMappings = ({
  types
}) => {
  const mappings = (0, _lodash.cloneDeep)((0, _core.getBaseMappings)());
  const typeMappings = (0, _core.buildTypesMappings)(types);
  mappings.properties = {
    ...mappings.properties,
    ...typeMappings
  };
  mappings._meta = buildIndexMeta({
    types
  });
  return mappings;
};
exports.buildIndexMappings = buildIndexMappings;
/**
 * Build the mapping _meta field to use when creating a new index.
 *
 * @param types The list of all registered SO types.
 */
const buildIndexMeta = ({
  types
}) => {
  const typeVersions = (0, _coreSavedObjectsBaseServerInternal.getVirtualVersionMap)(types);
  return {
    mappingVersions: typeVersions,
    docVersions: typeVersions,
    migrationState: {
      convertingDocuments: false
    }
  };
};
exports.buildIndexMeta = buildIndexMeta;