"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openPit = exports.DEFAULT_PIT_KEEP_ALIVE = void 0;
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _catch_retryable_es_client_errors = require("./catch_retryable_es_client_errors");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/** @internal */

/** @internal */

// how long ES should keep PIT alive
const DEFAULT_PIT_KEEP_ALIVE = exports.DEFAULT_PIT_KEEP_ALIVE = '10m';
/*
 * Creates a lightweight view of data when the request has been initiated.
 * See https://www.elastic.co/guide/en/elasticsearch/reference/current/point-in-time-api.html
 * */
const openPit = ({
  client,
  index
}) => () => {
  return client.openPointInTime({
    index,
    keep_alive: DEFAULT_PIT_KEEP_ALIVE
  }).then(response => Either.right({
    pitId: response.id
  })).catch(_catch_retryable_es_client_errors.catchRetryableEsClientErrors);
};
exports.openPit = openPit;