"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.compareVirtualVersions = void 0;
var _semver = _interopRequireDefault(require("semver"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * The overall status of the model version comparison:
 * - `greater`: app version is greater than the index version
 * - `lesser`: app version is lesser than the index version
 * - `equal`: app version is equal to the index version
 * - `conflict`: app and index versions are incompatible (versions for some types are higher, and for other types lower)
 */

const compareVirtualVersions = ({
  appVersions,
  indexVersions,
  deletedTypes
}) => {
  const allTypes = [...new Set([...Object.keys(appVersions), ...Object.keys(indexVersions)])].filter(type => !deletedTypes.includes(type));
  const details = {
    greater: [],
    lesser: [],
    equal: []
  };
  allTypes.forEach(type => {
    var _appVersions$type, _indexVersions$type;
    const appVersion = (_appVersions$type = appVersions[type]) !== null && _appVersions$type !== void 0 ? _appVersions$type : '0.0.0';
    const indexVersion = (_indexVersions$type = indexVersions[type]) !== null && _indexVersions$type !== void 0 ? _indexVersions$type : '0.0.0';
    const comparison = _semver.default.compare(appVersion, indexVersion);
    if (comparison > 0) {
      // app version greater than index version
      details.greater.push(type);
    } else if (comparison < 0) {
      // app version lower than index version
      details.lesser.push(type);
    } else {
      // // app version equal to index version
      details.equal.push(type);
    }
  });
  const hasGreater = details.greater.length > 0;
  const hasLesser = details.lesser.length > 0;
  const status = hasGreater && hasLesser ? 'conflict' : hasGreater ? 'greater' : hasLesser ? 'lesser' : 'equal';
  return {
    status,
    details
  };
};
exports.compareVirtualVersions = compareVirtualVersions;