"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performUpdateObjectsSpaces = void 0;
var _update_objects_spaces = require("./internals/update_objects_spaces");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const performUpdateObjectsSpaces = async ({
  objects,
  spacesToAdd,
  spacesToRemove,
  options
}, {
  registry,
  helpers,
  allowedTypes,
  client,
  serializer,
  logger,
  mappings,
  extensions = {}
}) => {
  const {
    common: commonHelper
  } = helpers;
  const {
    securityExtension
  } = extensions;
  const namespace = commonHelper.getCurrentNamespace(options.namespace);
  return (0, _update_objects_spaces.updateObjectsSpaces)({
    mappings,
    registry,
    allowedTypes,
    client,
    serializer,
    logger,
    getIndexForType: commonHelper.getIndexForType.bind(commonHelper),
    securityExtension,
    objects,
    spacesToAdd,
    spacesToRemove,
    options: {
      ...options,
      namespace
    }
  });
};
exports.performUpdateObjectsSpaces = performUpdateObjectsSpaces;