"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serverlessConfig = exports.VALID_SERVERLESS_PROJECT_TYPES = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Config validation for how to run Kibana in Serverless mode.
// Clients need to specify the project type to run in.
// Going for a simple `serverless` string because it serves as
// a direct replacement to the legacy --serverless CLI flag.
// If we even decide to extend this further, and converting it into an object,
// BWC can be ensured by adding the object definition as another alternative to `schema.oneOf`.

const VALID_SERVERLESS_PROJECT_TYPES = exports.VALID_SERVERLESS_PROJECT_TYPES = ['es', 'oblt', 'security'];
const serverlessConfigSchema = _configSchema.schema.maybe(_configSchema.schema.oneOf(VALID_SERVERLESS_PROJECT_TYPES.map(projectName => _configSchema.schema.literal(projectName))));
const serverlessConfig = exports.serverlessConfig = {
  path: 'serverless',
  schema: serverlessConfigSchema
};