"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RouteValidationError = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Error to return when the validation is not successful.
 * @public
 */
class RouteValidationError extends _configSchema.SchemaTypeError {
  constructor(error, path = []) {
    super(error, path);

    // Set the prototype explicitly, see:
    // https://github.com/Microsoft/TypeScript/wiki/Breaking-Changes#extending-built-ins-like-error-array-and-map-may-no-longer-work
    Object.setPrototypeOf(this, RouteValidationError.prototype);
  }
}

/**
 * Validation result factory to be used in the custom validation function to return the valid data or validation errors
 *
 * See {@link RouteValidationFunction}.
 *
 * @public
 */

/**
 * The custom validation function if @kbn/config-schema is not a valid solution for your specific plugin requirements.
 *
 * @example
 *
 * The validation should look something like:
 * ```typescript
 * interface MyExpectedBody {
 *   bar: string;
 *   baz: number;
 * }
 *
 * const myBodyValidation: RouteValidationFunction<MyExpectedBody> = (data, validationResult) => {
 *   const { ok, badRequest } = validationResult;
 *   const { bar, baz } = data || {};
 *   if (typeof bar === 'string' && typeof baz === 'number') {
 *     return ok({ bar, baz });
 *   } else {
 *     return badRequest('Wrong payload', ['body']);
 *   }
 * }
 * ```
 *
 * @public
 */

/**
 * Allowed property validation options: either @kbn/config-schema validations or custom validation functions
 *
 * See {@link RouteValidationFunction} for custom validation.
 *
 * @public
 */

/**
 * The configuration object to the RouteValidator class.
 * Set `params`, `query` and/or `body` to specify the validation logic to follow for that property.
 *
 * @public
 */

/**
 * Additional options for the RouteValidator class to modify its default behaviour.
 *
 * @public
 */

/**
 * Route validations config and options merged into one object
 * @public
 */

/**
 * Map of status codes to response schemas.
 *
 * @note Response schemas can be expensive to instantiate. We expect consumers
 * to provide these schemas lazily since they may not be needed.
 *
 * @note The {@link TypeOf} type utility from @kbn/config-schema can extract
 * types from lazily created schemas
 *
 * @example
 *
 * ```ts
 * // Avoid this:
 * const responseSchema = schema.object({ foo: foo.string() });
 * // Do this:
 * const lazyResponseSchema = () => schema.object({ foo: foo.string() });
 *
 * type ResponseType = TypeOf<typeof lazyResponseSchema>; // Can take a func
 * ...
 * router.post(
 *  { validation: { response: responseSchema } },
 *  handlerFn
 * )
 * ...
 * ```
 * @public
 */

/**
 * An alternative form to register both request schema and all response schemas.
 * @public
 */

/**
 * Type container for schemas used in route related validations
 * @public
 */

/**
 * A validation schema factory.
 *
 * @note Used to lazily create schemas that are otherwise not needed
 * @note Assume this function will only be called once
 *
 * @return A @kbn/config-schema schema
 * @public
 */
exports.RouteValidationError = RouteValidationError;