"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isInlineScriptingEnabled = void 0;
var _rxjs = require("rxjs");
var _retryable_es_client_errors = require("./retryable_es_client_errors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const scriptAllowedTypesKey = 'script.allowed_types';
const isInlineScriptingEnabled = async ({
  client,
  maxRetries = 20,
  maxRetryDelay = 64
}) => {
  return (0, _rxjs.firstValueFrom)((0, _rxjs.defer)(() => {
    return client.cluster.getSettings({
      include_defaults: true,
      flat_settings: true
    });
  }).pipe((0, _rxjs.retry)({
    count: maxRetries,
    delay: (error, retryIndex) => {
      if ((0, _retryable_es_client_errors.isRetryableEsClientError)(error)) {
        const retryDelay = 1000 * Math.min(Math.pow(2, retryIndex), maxRetryDelay); // 2s, 4s, 8s, 16s, 32s, 64s, 64s, 64s ...
        return (0, _rxjs.timer)(retryDelay);
      } else {
        return (0, _rxjs.throwError)(error);
      }
    }
  }), (0, _rxjs.map)(settings => {
    var _ref, _ref2, _settings$transient$s;
    const scriptAllowedTypes = (_ref = (_ref2 = (_settings$transient$s = settings.transient[scriptAllowedTypesKey]) !== null && _settings$transient$s !== void 0 ? _settings$transient$s : settings.persistent[scriptAllowedTypesKey]) !== null && _ref2 !== void 0 ? _ref2 : settings.defaults[scriptAllowedTypesKey]) !== null && _ref !== void 0 ? _ref : [];
    return scriptAllowedTypes.length === 0 || scriptAllowedTypes.includes('inline');
  })));
};
exports.isInlineScriptingEnabled = isInlineScriptingEnabled;