"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getValidationAggregationBuilder = void 0;
var _common = require("@kbn/data-views-plugin/common");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Validation aggregations
 */
const getValidationAggregationBuilder = () => ({
  buildAggregation: ({
    selectedOptions,
    fieldName,
    fieldSpec
  }) => {
    var _selectedOptionsFilte;
    let selectedOptionsFilters;
    if (selectedOptions) {
      selectedOptionsFilters = selectedOptions.reduce((acc, currentOption) => {
        acc[currentOption] = {
          match: {
            [fieldName]: String(currentOption)
          }
        };
        return acc;
      }, {});
    }
    if ((0, _lodash.isEmpty)((_selectedOptionsFilte = selectedOptionsFilters) !== null && _selectedOptionsFilte !== void 0 ? _selectedOptionsFilte : [])) {
      return {};
    }
    let validationAggregation = {
      validation: {
        filters: {
          filters: selectedOptionsFilters
        }
      }
    };
    const isNested = fieldSpec && (0, _common.getFieldSubtypeNested)(fieldSpec);
    if (isNested) {
      validationAggregation = {
        nestedValidation: {
          nested: {
            path: isNested.nested.path
          },
          aggs: {
            ...validationAggregation
          }
        }
      };
    }
    return validationAggregation;
  },
  parse: (rawEsResult, {
    fieldSpec
  }) => {
    const isNested = fieldSpec && (0, _common.getFieldSubtypeNested)(fieldSpec);
    const rawInvalidSuggestions = (0, _lodash.get)(rawEsResult, isNested ? 'aggregations.nestedValidation.validation.buckets' : 'aggregations.validation.buckets');
    return rawInvalidSuggestions && !(0, _lodash.isEmpty)(rawInvalidSuggestions) ? Object.keys(rawInvalidSuggestions).filter(key => rawInvalidSuggestions[key].doc_count === 0) : [];
  }
});
exports.getValidationAggregationBuilder = getValidationAggregationBuilder;