"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSliderStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TimeSliderStrings = exports.TimeSliderStrings = {
  control: {
    getPinStart: () => _i18n.i18n.translate('controls.timeSlider.settings.pinStart', {
      defaultMessage: 'Pin start'
    }),
    getUnpinStart: () => _i18n.i18n.translate('controls.timeSlider.settings.unpinStart', {
      defaultMessage: 'Unpin start'
    }),
    getPlayButtonAriaLabel: isPaused => isPaused ? _i18n.i18n.translate('controls.timeSlider.playLabel', {
      defaultMessage: 'Play'
    }) : _i18n.i18n.translate('controls.timeSlider.pauseLabel', {
      defaultMessage: 'Pause'
    }),
    getPreviousButtonAriaLabel: () => _i18n.i18n.translate('controls.timeSlider.previousLabel', {
      defaultMessage: 'Previous time window'
    }),
    getNextButtonAriaLabel: () => _i18n.i18n.translate('controls.timeSlider.nextLabel', {
      defaultMessage: 'Next time window'
    }),
    getPlayButtonDisabledTooltip: () => _i18n.i18n.translate('controls.timeSlider.playButtonTooltip.disabled', {
      defaultMessage: '"Apply selections automatically" is disabled in Control Settings.'
    })
  }
};