"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSlider = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _time_slider_embeddable = require("../embeddable/time_slider_embeddable");
var _time_slider_selectors = require("../time_slider_selectors");
var _time_utils = require("../time_utils");
var _time_slider_popover_button = require("./time_slider_popover_button");
var _time_slider_popover_content = require("./time_slider_popover_content");
require("./index.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TimeSlider = props => {
  const timeSlider = (0, _time_slider_embeddable.useTimeSlider)();
  const stepSize = timeSlider.select(state => {
    return state.componentState.stepSize;
  });
  const ticks = timeSlider.select(state => {
    return state.componentState.ticks;
  });
  const timeRangeBounds = timeSlider.select(_time_slider_selectors.getRoundedTimeRangeBounds);
  const timeRangeMin = timeRangeBounds[_time_utils.FROM_INDEX];
  const timeRangeMax = timeRangeBounds[_time_utils.TO_INDEX];
  const value = timeSlider.select(state => {
    return state.componentState.value;
  });
  const isOpen = timeSlider.select(state => {
    return state.componentState.isOpen;
  });
  const from = value ? value[_time_utils.FROM_INDEX] : timeRangeMin;
  const to = value ? value[_time_utils.TO_INDEX] : timeRangeMax;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    className: "timeSlider__popoverOverride",
    panelClassName: "timeSlider__panelOverride",
    input: /*#__PURE__*/_react.default.createElement(_time_slider_popover_button.TimeSliderPopoverButton, {
      onClick: () => {
        timeSlider.dispatch.setIsOpen({
          isOpen: !isOpen
        });
      },
      formatDate: props.formatDate,
      from: from,
      to: to
    }),
    isOpen: isOpen,
    closePopover: () => timeSlider.dispatch.setIsOpen({
      isOpen: false
    }),
    panelPaddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_time_slider_popover_content.TimeSliderPopoverContent, {
    value: [from, to],
    onChange: props.onChange,
    stepSize: stepSize,
    ticks: ticks,
    timeRangeMin: timeRangeMin,
    timeRangeMax: timeRangeMax
  }));
};
exports.TimeSlider = TimeSlider;