"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _public = require("@kbn/presentation-util-plugin/public");
var _range_slider_persistable_state = require("../../../common/range_slider/range_slider_persistable_state");
var _types = require("../../../common/range_slider/types");
var _range_slider_editor_options = require("../components/range_slider_editor_options");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
class RangeSliderEmbeddableFactory {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _types.RANGE_SLIDER_CONTROL);
    (0, _defineProperty2.default)(this, "getDisplayName", () => _i18n.i18n.translate('controls.rangeSlider.displayName', {
      defaultMessage: 'Range slider'
    }));
    (0, _defineProperty2.default)(this, "getDescription", () => _i18n.i18n.translate('controls.rangeSlider.description', {
      defaultMessage: 'Add a control for selecting a range of field values.'
    }));
    (0, _defineProperty2.default)(this, "getIconType", () => 'controlsHorizontal');
    (0, _defineProperty2.default)(this, "canCreateNew", () => false);
    (0, _defineProperty2.default)(this, "isEditable", () => Promise.resolve(true));
    (0, _defineProperty2.default)(this, "controlEditorOptionsComponent", _range_slider_editor_options.RangeSliderEditorOptions);
    (0, _defineProperty2.default)(this, "presaveTransformFunction", (newInput, embeddable) => {
      if (embeddable && (newInput.fieldName && !(0, _fastDeepEqual.default)(newInput.fieldName, embeddable.getInput().fieldName) || newInput.dataViewId && !(0, _fastDeepEqual.default)(newInput.dataViewId, embeddable.getInput().dataViewId))) {
        // if the field name or data view id has changed in this editing session, selected values are invalid, so reset them.
        newInput.value = ['', ''];
      }
      return newInput;
    });
    (0, _defineProperty2.default)(this, "isFieldCompatible", field => {
      return field.aggregatable && field.type === 'number';
    });
    (0, _defineProperty2.default)(this, "inject", (0, _range_slider_persistable_state.createRangeSliderInject)());
    (0, _defineProperty2.default)(this, "extract", (0, _range_slider_persistable_state.createRangeSliderExtract)());
  }
  async create(initialInput, parent) {
    const reduxEmbeddablePackage = await (0, _public.lazyLoadReduxToolsPackage)();
    const {
      RangeSliderEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./range_slider_embeddable')));
    return Promise.resolve(new RangeSliderEmbeddable(reduxEmbeddablePackage, initialInput, {}, parent));
  }
}
exports.RangeSliderEmbeddableFactory = RangeSliderEmbeddableFactory;