"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderStrings = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RangeSliderStrings = exports.RangeSliderStrings = {
  control: {
    getInvalidSelectionWarningLabel: () => _i18n.i18n.translate('controls.rangeSlider.control.invalidSelectionWarningLabel', {
      defaultMessage: 'Selected range returns no results.'
    })
  },
  editor: {
    getStepTitle: () => _i18n.i18n.translate('controls.rangeSlider.editor.stepSizeTitle', {
      defaultMessage: 'Step size'
    })
  },
  popover: {
    getNoAvailableDataHelpText: () => _i18n.i18n.translate('controls.rangeSlider.popover.noAvailableDataHelpText', {
      defaultMessage: 'There is no data to display. Adjust the time range and filters.'
    })
  }
};