"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeSliderEditorOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _range_slider_strings = require("./range_slider_strings");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const RangeSliderEditorOptions = ({
  initialInput,
  onChange,
  setControlEditorValid
}) => {
  const [step, setStep] = (0, _react.useState)((initialInput === null || initialInput === void 0 ? void 0 : initialInput.step) || 1);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _range_slider_strings.RangeSliderStrings.editor.getStepTitle()
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: step,
    onChange: event => {
      const newStep = event.target.valueAsNumber;
      onChange({
        step: newStep
      });
      setStep(newStep);
      setControlEditorValid(newStep > 0);
    },
    min: 0,
    isInvalid: step <= 0,
    "data-test-subj": "rangeSliderControl__stepAdditionalSetting"
  })));
};
exports.RangeSliderEditorOptions = RangeSliderEditorOptions;