"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListControl = void 0;
var _classnames = _interopRequireDefault(require("classnames"));
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _types = require("../types");
var _options_list_strings = require("./options_list_strings");
var _options_list_popover = require("./options_list_popover");
var _options_list_embeddable = require("../embeddable/options_list_embeddable");
require("./options_list.scss");
var _control_error_component = require("../../control_group/component/control_error_component");
var _constants = require("../../constants");
var _use_field_formatter = require("../../hooks/use_field_formatter");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const OptionsListControl = ({
  typeaheadSubject,
  loadMoreSubject
}) => {
  const optionsList = (0, _options_list_embeddable.useOptionsList)();
  const popoverId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const error = optionsList.select(state => state.componentState.error);
  const isPopoverOpen = optionsList.select(state => state.componentState.popoverOpen);
  const invalidSelections = optionsList.select(state => state.componentState.invalidSelections);
  const fieldSpec = optionsList.select(state => state.componentState.field);
  const id = optionsList.select(state => state.explicitInput.id);
  const exclude = optionsList.select(state => state.explicitInput.exclude);
  const fieldName = optionsList.select(state => state.explicitInput.fieldName);
  const fieldTitle = optionsList.select(state => state.explicitInput.title);
  const placeholder = optionsList.select(state => state.explicitInput.placeholder);
  const controlStyle = optionsList.select(state => state.explicitInput.controlStyle);
  const singleSelect = optionsList.select(state => state.explicitInput.singleSelect);
  const existsSelected = optionsList.select(state => state.explicitInput.existsSelected);
  const selectedOptions = optionsList.select(state => state.explicitInput.selectedOptions);
  const loading = optionsList.select(state => state.output.loading);
  const dataViewId = optionsList.select(state => state.output.dataViewId);
  const fieldFormatter = (0, _use_field_formatter.useFieldFormatter)({
    dataViewId,
    fieldSpec
  });
  (0, _react.useEffect)(() => {
    return () => {
      optionsList.dispatch.setPopoverOpen(false); // on unmount, close the popover
    };
  }, [optionsList]);

  // debounce loading state so loading doesn't flash when user types
  const [debouncedLoading, setDebouncedLoading] = (0, _react.useState)(true);
  const debounceSetLoading = (0, _react.useMemo)(() => (0, _lodash.debounce)(latestLoading => {
    setDebouncedLoading(latestLoading);
  }, 100), []);
  (0, _react.useEffect)(() => debounceSetLoading(loading !== null && loading !== void 0 ? loading : false), [loading, debounceSetLoading]);

  // remove all other selections if this control is single select
  (0, _react.useEffect)(() => {
    if (singleSelect && selectedOptions && (selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length) > 1) {
      optionsList.dispatch.replaceSelection(selectedOptions[0]);
    }
  }, [selectedOptions, singleSelect, optionsList.dispatch]);
  const updateSearchString = (0, _react.useCallback)(newSearchString => {
    typeaheadSubject.next(newSearchString);
    optionsList.dispatch.setSearchString(newSearchString);
  }, [typeaheadSubject, optionsList.dispatch]);
  const loadMoreSuggestions = (0, _react.useCallback)(cardinality => {
    loadMoreSubject.next(Math.min(cardinality, _types.MAX_OPTIONS_LIST_REQUEST_SIZE));
  }, [loadMoreSubject]);
  const delimiter = (0, _react.useMemo)(() => _options_list_strings.OptionsListStrings.control.getSeparator(fieldSpec === null || fieldSpec === void 0 ? void 0 : fieldSpec.type), [fieldSpec === null || fieldSpec === void 0 ? void 0 : fieldSpec.type]);
  const {
    hasSelections,
    selectionDisplayNode,
    selectedOptionsCount
  } = (0, _react.useMemo)(() => {
    return {
      hasSelections: !(0, _lodash.isEmpty)(selectedOptions),
      selectedOptionsCount: selectedOptions === null || selectedOptions === void 0 ? void 0 : selectedOptions.length,
      selectionDisplayNode: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        responsive: false,
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        className: "optionsList__selections"
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "eui-textTruncate"
      }, exclude && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
        className: "optionsList__negateLabel"
      }, existsSelected ? _options_list_strings.OptionsListStrings.control.getExcludeExists() : _options_list_strings.OptionsListStrings.control.getNegate()), ' '), existsSelected ? /*#__PURE__*/_react.default.createElement("span", {
        className: `optionsList__existsFilter`
      }, _options_list_strings.OptionsListStrings.controlAndPopover.getExists(+Boolean(exclude))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, selectedOptions !== null && selectedOptions !== void 0 && selectedOptions.length ? selectedOptions.map((value, i, {
        length
      }) => {
        const text = `${fieldFormatter(value)}${i + 1 === length ? '' : delimiter} `;
        const isInvalid = invalidSelections === null || invalidSelections === void 0 ? void 0 : invalidSelections.includes(value);
        return /*#__PURE__*/_react.default.createElement("span", {
          className: `optionsList__filter ${isInvalid ? 'optionsList__filterInvalid' : ''}`
        }, text);
      }) : null))), invalidSelections && invalidSelections.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        position: "top",
        content: _options_list_strings.OptionsListStrings.control.getInvalidSelectionWarningLabel(invalidSelections.length),
        delay: "long"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToken, {
        tabIndex: 0,
        iconType: "alert",
        size: "s",
        color: "euiColorVis5",
        shape: "square",
        fill: "dark",
        title: _options_list_strings.OptionsListStrings.control.getInvalidSelectionWarningLabel(invalidSelections.length),
        css: {
          verticalAlign: 'text-bottom'
        } // Align with the notification badge
      }))))
    };
  }, [selectedOptions, exclude, existsSelected, fieldFormatter, delimiter, invalidSelections]);
  const button = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    badgeColor: "success",
    iconType: "arrowDown",
    isLoading: debouncedLoading,
    className: (0, _classnames.default)('optionsList--filterBtn', {
      'optionsList--filterBtnSingle': controlStyle !== 'twoLine',
      'optionsList--filterBtnPlaceholder': !hasSelections
    }),
    "data-test-subj": `optionsList-control-${id}`,
    onClick: () => optionsList.dispatch.setPopoverOpen(!isPopoverOpen),
    isSelected: isPopoverOpen,
    numActiveFilters: selectedOptionsCount,
    hasActiveFilters: Boolean(selectedOptionsCount),
    textProps: {
      className: 'optionsList--selectionText'
    },
    "aria-label": fieldTitle !== null && fieldTitle !== void 0 ? fieldTitle : fieldName,
    "aria-expanded": isPopoverOpen,
    "aria-controls": popoverId,
    role: "combobox"
  }, hasSelections || existsSelected ? selectionDisplayNode : placeholder !== null && placeholder !== void 0 ? placeholder : _options_list_strings.OptionsListStrings.control.getPlaceholder()));
  return error ? /*#__PURE__*/_react.default.createElement(_control_error_component.ControlError, {
    error: error
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    className: (0, _classnames.default)('optionsList--filterGroup', {
      'optionsList--filterGroupSingle': controlStyle !== 'twoLine'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    id: popoverId,
    ownFocus: true,
    input: button,
    hasArrow: false,
    repositionOnScroll: true,
    isOpen: isPopoverOpen,
    panelPaddingSize: "none",
    panelMinWidth: _constants.MIN_POPOVER_WIDTH,
    className: "optionsList__inputButtonOverride",
    initialFocus: '[data-test-subj=optionsList-control-search-input]',
    closePopover: () => optionsList.dispatch.setPopoverOpen(false),
    panelClassName: "optionsList__popoverOverride",
    panelProps: {
      'aria-label': _options_list_strings.OptionsListStrings.popover.getAriaLabel(fieldTitle !== null && fieldTitle !== void 0 ? fieldTitle : fieldName)
    }
  }, /*#__PURE__*/_react.default.createElement(_options_list_popover.OptionsListPopover, {
    isLoading: debouncedLoading,
    updateSearchString: updateSearchString,
    loadMoreSuggestions: loadMoreSuggestions
  })));
};
exports.OptionsListControl = OptionsListControl;