"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controlGroupReducers = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const controlGroupReducers = exports.controlGroupReducers = {
  setControlWithInvalidSelectionsId: (state, action) => {
    state.componentState.controlWithInvalidSelectionsId = action.payload;
  },
  setLastSavedInput: (state, action) => {
    state.componentState.lastSavedInput = action.payload;
  },
  setLastSavedFilters: (state, action) => {
    state.componentState.lastSavedFilters = action.payload;
  },
  setUnpublishedFilters: (state, action) => {
    state.componentState.unpublishedFilters = action.payload;
  },
  setControlStyle: (state, action) => {
    state.explicitInput.controlStyle = action.payload;
  },
  setChainingSystem: (state, action) => {
    state.explicitInput.chainingSystem = action.payload;
  },
  setDefaultControlWidth: (state, action) => {
    state.explicitInput.defaultControlWidth = action.payload;
  },
  setDefaultControlGrow: (state, action) => {
    state.explicitInput.defaultControlGrow = action.payload;
  },
  setControlWidth: (state, action) => {
    state.explicitInput.panels[action.payload.embeddableId].width = action.payload.width;
  },
  setControlGrow: (state, action) => {
    state.explicitInput.panels[action.payload.embeddableId].grow = action.payload.grow;
  },
  setControlOrders: (state, action) => {
    action.payload.ids.forEach((id, index) => {
      state.explicitInput.panels[id].order = index;
    });
  }
};