"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializableToRawControlGroupAttributes = exports.rawControlGroupAttributesToSerializable = exports.rawControlGroupAttributesToControlGroupInput = exports.persistableControlGroupInputIsEqual = exports.getDefaultControlGroupPersistableInput = exports.getDefaultControlGroupInput = exports.generateNewControlIds = exports.controlGroupInputToRawControlGroupAttributes = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _uuid = require("uuid");
var _lodash = require("lodash");
var _control_group_constants = require("./control_group_constants");
var _control_group_panel_diff_system = require("./control_group_panel_diff_system");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const safeJSONParse = jsonString => {
  if (!jsonString && typeof jsonString !== 'string') return;
  try {
    return JSON.parse(jsonString);
  } catch {
    return;
  }
};
const getDefaultControlGroupInput = () => ({
  panels: {},
  defaultControlWidth: _control_group_constants.DEFAULT_CONTROL_WIDTH,
  defaultControlGrow: _control_group_constants.DEFAULT_CONTROL_GROW,
  controlStyle: _control_group_constants.DEFAULT_CONTROL_STYLE,
  chainingSystem: 'HIERARCHICAL',
  showApplySelections: false,
  ignoreParentSettings: {
    ignoreFilters: false,
    ignoreQuery: false,
    ignoreTimerange: false,
    ignoreValidations: false
  }
});
exports.getDefaultControlGroupInput = getDefaultControlGroupInput;
const getDefaultControlGroupPersistableInput = () => (0, _lodash.pick)(getDefaultControlGroupInput(), _types.persistableControlGroupInputKeys);
exports.getDefaultControlGroupPersistableInput = getDefaultControlGroupPersistableInput;
const persistableControlGroupInputIsEqual = (a, b, compareSelections = true) => {
  const defaultInput = getDefaultControlGroupPersistableInput();
  const inputA = {
    ...defaultInput,
    ...(0, _lodash.pick)(a, _types.persistableControlGroupInputKeys)
  };
  const inputB = {
    ...defaultInput,
    ...(0, _lodash.pick)(b, _types.persistableControlGroupInputKeys)
  };
  return getPanelsAreEqual(inputA.panels, inputB.panels, compareSelections) && (0, _fastDeepEqual.default)((0, _lodash.omit)(inputA, ['panels']), (0, _lodash.omit)(inputB, ['panels']));
};
exports.persistableControlGroupInputIsEqual = persistableControlGroupInputIsEqual;
const getPanelsAreEqual = (originalPanels, newPanels, compareSelections) => {
  const originalPanelIds = Object.keys(originalPanels);
  const newPanelIds = Object.keys(newPanels);
  const panelIdDiff = (0, _lodash.xor)(originalPanelIds, newPanelIds);
  if (panelIdDiff.length > 0) {
    return false;
  }
  for (const panelId of newPanelIds) {
    const newPanelType = newPanels[panelId].type;
    const panelIsEqual = _control_group_panel_diff_system.ControlPanelDiffSystems[newPanelType] ? _control_group_panel_diff_system.ControlPanelDiffSystems[newPanelType].getPanelIsEqual(originalPanels[panelId], newPanels[panelId], compareSelections) : _control_group_panel_diff_system.genericControlPanelDiffSystem.getPanelIsEqual(originalPanels[panelId], newPanels[panelId]);
    if (!panelIsEqual) return false;
  }
  return true;
};
const controlGroupInputToRawControlGroupAttributes = controlGroupInput => {
  return {
    controlStyle: controlGroupInput.controlStyle,
    chainingSystem: controlGroupInput.chainingSystem,
    showApplySelections: controlGroupInput.showApplySelections,
    panelsJSON: JSON.stringify(controlGroupInput.panels),
    ignoreParentSettingsJSON: JSON.stringify(controlGroupInput.ignoreParentSettings)
  };
};
exports.controlGroupInputToRawControlGroupAttributes = controlGroupInputToRawControlGroupAttributes;
const generateNewControlIds = controlGroupInput => {
  if (!(controlGroupInput !== null && controlGroupInput !== void 0 && controlGroupInput.panels)) return;
  const newPanelsMap = {};
  for (const panel of Object.values(controlGroupInput.panels)) {
    const newId = (0, _uuid.v4)();
    newPanelsMap[newId] = {
      ...panel,
      explicitInput: {
        ...panel.explicitInput,
        id: newId
      }
    };
  }
  return {
    ...controlGroupInput,
    panels: newPanelsMap
  };
};
exports.generateNewControlIds = generateNewControlIds;
const rawControlGroupAttributesToControlGroupInput = rawControlGroupAttributes => {
  const defaultControlGroupInput = getDefaultControlGroupInput();
  const {
    chainingSystem,
    controlStyle,
    showApplySelections,
    ignoreParentSettingsJSON,
    panelsJSON
  } = rawControlGroupAttributes;
  const panels = safeJSONParse(panelsJSON);
  const ignoreParentSettings = safeJSONParse(ignoreParentSettingsJSON);
  return {
    ...defaultControlGroupInput,
    ...(chainingSystem ? {
      chainingSystem
    } : {}),
    ...(controlStyle ? {
      controlStyle
    } : {}),
    ...(showApplySelections ? {
      showApplySelections
    } : {}),
    ...(ignoreParentSettings ? {
      ignoreParentSettings
    } : {}),
    ...(panels ? {
      panels
    } : {})
  };
};
exports.rawControlGroupAttributesToControlGroupInput = rawControlGroupAttributesToControlGroupInput;
const rawControlGroupAttributesToSerializable = rawControlGroupAttributes => {
  var _rawControlGroupAttri, _safeJSONParse, _safeJSONParse2;
  const defaultControlGroupInput = getDefaultControlGroupInput();
  return {
    chainingSystem: rawControlGroupAttributes === null || rawControlGroupAttributes === void 0 ? void 0 : rawControlGroupAttributes.chainingSystem,
    controlStyle: (_rawControlGroupAttri = rawControlGroupAttributes === null || rawControlGroupAttributes === void 0 ? void 0 : rawControlGroupAttributes.controlStyle) !== null && _rawControlGroupAttri !== void 0 ? _rawControlGroupAttri : defaultControlGroupInput.controlStyle,
    showApplySelections: rawControlGroupAttributes === null || rawControlGroupAttributes === void 0 ? void 0 : rawControlGroupAttributes.showApplySelections,
    ignoreParentSettings: (_safeJSONParse = safeJSONParse(rawControlGroupAttributes === null || rawControlGroupAttributes === void 0 ? void 0 : rawControlGroupAttributes.ignoreParentSettingsJSON)) !== null && _safeJSONParse !== void 0 ? _safeJSONParse : {},
    panels: (_safeJSONParse2 = safeJSONParse(rawControlGroupAttributes === null || rawControlGroupAttributes === void 0 ? void 0 : rawControlGroupAttributes.panelsJSON)) !== null && _safeJSONParse2 !== void 0 ? _safeJSONParse2 : {}
  };
};
exports.rawControlGroupAttributesToSerializable = rawControlGroupAttributesToSerializable;
const serializableToRawControlGroupAttributes = serializable => {
  return {
    controlStyle: serializable.controlStyle,
    chainingSystem: serializable.chainingSystem,
    showApplySelections: Boolean(serializable.showApplySelections),
    ignoreParentSettingsJSON: JSON.stringify(serializable.ignoreParentSettings),
    panelsJSON: JSON.stringify(serializable.panels)
  };
};
exports.serializableToRawControlGroupAttributes = serializableToRawControlGroupAttributes;