"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _core = require("./core");
var _rpc = require("./rpc");
var _rpc2 = require("../common/rpc");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var _eventStream = /*#__PURE__*/new WeakMap();
class ContentManagementPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "core", void 0);
    _classPrivateFieldInitSpec(this, _eventStream, void 0);
    this.logger = initializerContext.logger.get();

    // TODO: Enable Event Stream once we ready to log events.
    // const kibanaVersion = initializerContext.env.packageInfo.version;
    // this.#eventStream = new EventStreamService({
    //   logger: this.logger,
    //   clientFactory: new EsEventStreamClientFactory({
    //     baseName: '.kibana',
    //     kibanaVersion,
    //     logger: this.logger,
    //   }),
    // });

    this.core = new _core.Core({
      logger: this.logger,
      eventStream: _classPrivateFieldGet(_eventStream, this)
    });
  }
  setup(core) {
    if (_classPrivateFieldGet(_eventStream, this)) {
      _classPrivateFieldGet(_eventStream, this).setup({
        core
      });
    }
    const {
      api: coreApi,
      contentRegistry
    } = this.core.setup();
    const rpc = new _rpc.RpcService();
    (0, _rpc.registerProcedures)(rpc);
    const router = core.http.createRouter();
    (0, _rpc.initRpcRoutes)(_rpc2.procedureNames, router, {
      rpc,
      contentRegistry
    });
    return {
      ...coreApi
    };
  }
  start(core) {
    if (_classPrivateFieldGet(_eventStream, this)) {
      _classPrivateFieldGet(_eventStream, this).start();
    }
    return {};
  }
  async stop() {
    if (_classPrivateFieldGet(_eventStream, this)) {
      try {
        await _classPrivateFieldGet(_eventStream, this).stop();
      } catch (e) {
        this.logger.error(`Error during event stream stop: ${e}`);
      }
    }
  }
}
exports.ContentManagementPlugin = ContentManagementPlugin;