"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryEventStreamClient = void 0;
var _util = require("./util");
function _classPrivateFieldInitSpec(obj, privateMap, value) { _checkPrivateRedeclaration(obj, privateMap); privateMap.set(obj, value); }
function _checkPrivateRedeclaration(obj, privateCollection) { if (privateCollection.has(obj)) { throw new TypeError("Cannot initialize the same private elements twice on an object"); } }
function _classPrivateFieldGet(s, a) { return s.get(_assertClassBrand(s, a)); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * This is an in-memory implementation of the {@link EventStreamClient}
 * interface (it does not persist events to Elasticsearch). It is useful for
 * testing and demo purposes.
 */
var _events = /*#__PURE__*/new WeakMap();
class MemoryEventStreamClient {
  constructor() {
    _classPrivateFieldInitSpec(this, _events, []);
  }
  async initialize() {}
  async writeEvents(events) {
    for (const event of events) {
      _classPrivateFieldGet(_events, this).push((0, _util.clone)(event));
    }
    _classPrivateFieldGet(_events, this).sort((a, b) => b.time - a.time);
  }
  async tail(limit = 100) {
    const tail = _classPrivateFieldGet(_events, this).slice(0, limit);
    return tail.map(_util.clone);
  }
  async filter(options) {
    var _options$limit;
    let events = [..._classPrivateFieldGet(_events, this)];
    const {
      subject,
      object,
      predicate,
      transaction,
      from,
      to
    } = options;
    if (subject && subject.length) {
      events = events.filter(event => {
        if (!event.subject) {
          return false;
        }
        return subject.some(([type, id]) => {
          if (!id) return type === event.subject[0];
          return type === event.subject[0] && id === event.subject[1];
        });
      });
    }
    if (object && object.length) {
      events = events.filter(event => {
        if (!event.object) {
          return false;
        }
        return object.some(([type, id]) => {
          if (!id) return type === event.object[0];
          return type === event.object[0] && id === event.object[1];
        });
      });
    }
    if (predicate && predicate.length) {
      events = events.filter(event => {
        if (!event.predicate) {
          return false;
        }
        return predicate.some(type => {
          if (type && type !== event.predicate[0]) {
            return false;
          }
          return true;
        });
      });
    }
    if (transaction && transaction.length) {
      events = events.filter(event => {
        return !event.transaction ? false : transaction.some(id => event.transaction === id);
      });
    }
    if (from) {
      events = events.filter(event => event.time >= from);
    }
    if (to) {
      events = events.filter(event => event.time <= to);
    }
    const size = (_options$limit = options.limit) !== null && _options$limit !== void 0 ? _options$limit : 100;
    const offset = options.cursor ? JSON.parse(options.cursor) : 0;
    events = events.slice(offset);
    if (events.length > size) {
      events = events.slice(0, size);
    }
    let cursor = '';
    if (events.length >= size) {
      cursor = JSON.stringify(offset + size);
    }
    return {
      cursor,
      events: events.map(_util.clone)
    };
  }
}
exports.MemoryEventStreamClient = MemoryEventStreamClient;