"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkGetSchemas = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("./constants");
var _get = require("./get");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const bulkGetSchemas = exports.bulkGetSchemas = {
  in: _configSchema.schema.object({
    contentTypeId: _configSchema.schema.string(),
    version: _constants.versionSchema,
    ids: _configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      minSize: 1
    }),
    options: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  }, {
    unknowns: 'forbid'
  }),
  out: _configSchema.schema.object({
    hits: _configSchema.schema.arrayOf(_get.getResultSchema),
    meta: _configSchema.schema.maybe(_configSchema.schema.object({}, {
      unknowns: 'allow'
    }))
  }, {
    unknowns: 'forbid'
  })
};