"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsLegacyConfigService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class EsLegacyConfigService {
  constructor() {
    /**
     * The elasticsearch config value at a given point in time.
     */
    (0, _defineProperty2.default)(this, "config", void 0);
    /**
     * An observable that emits elasticsearch config.
     */
    (0, _defineProperty2.default)(this, "config$", void 0);
    /**
     * A reference to the subscription to the elasticsearch observable
     */
    (0, _defineProperty2.default)(this, "configSub", void 0);
    /**
     * URL to cloud instance of elasticsearch if available
     */
    (0, _defineProperty2.default)(this, "cloudUrl", void 0);
  }
  setup(config$, cloud) {
    this.config$ = config$;
    this.configSub = this.config$.subscribe(config => {
      this.config = config;
    });
    this.cloudUrl = cloud === null || cloud === void 0 ? void 0 : cloud.elasticsearchUrl;
  }
  stop() {
    if (this.configSub) {
      this.configSub.unsubscribe();
    }
  }
  async readConfig() {
    if (!this.config$) {
      throw new Error('Could not read elasticsearch config, this service has not been setup!');
    }
    if (!this.config) {
      return (0, _rxjs.firstValueFrom)(this.config$);
    }
    return this.config;
  }
  getCloudUrl() {
    return this.cloudUrl;
  }
}
exports.EsLegacyConfigService = EsLegacyConfigService;