"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableConsoleInfo = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const CONSOLE_HEIGHT_KEY = 'embeddedConsoleHeight';
const CONSOLE_HEIGHT_LOCAL_STORAGE_DEBOUNCE_WAIT_TIME = 500;
class EmbeddableConsoleInfo {
  constructor(storage) {
    (0, _defineProperty2.default)(this, "_dispatch", null);
    (0, _defineProperty2.default)(this, "_alternateView", void 0);
    this.storage = storage;
    this.setConsoleHeight = (0, _lodash.debounce)(this.setConsoleHeight.bind(this), CONSOLE_HEIGHT_LOCAL_STORAGE_DEBOUNCE_WAIT_TIME);
  }
  get alternateView() {
    return this._alternateView;
  }
  setDispatch(d) {
    this._dispatch = d;
  }
  isEmbeddedConsoleAvailable() {
    return this._dispatch !== null;
  }
  openEmbeddedConsole(content) {
    // Embedded Console is not rendered on the page, nothing to do
    if (!this._dispatch) return;
    this._dispatch({
      type: 'open',
      payload: content ? {
        content
      } : undefined
    });
  }
  registerAlternateView(view) {
    this._alternateView = view !== null && view !== void 0 ? view : undefined;
  }
  getConsoleHeight() {
    return this.storage.get(CONSOLE_HEIGHT_KEY, undefined);
  }
  setConsoleHeight(value) {
    this.storage.set(CONSOLE_HEIGHT_KEY, value);
  }
}
exports.EmbeddableConsoleInfo = EmbeddableConsoleInfo;