"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStream = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class DataStream {
  constructor() {
    (0, _defineProperty2.default)(this, "dataStreams", []);
    (0, _defineProperty2.default)(this, "perDataStreamIndices", {});
    (0, _defineProperty2.default)(this, "getDataStreams", () => {
      return [...this.dataStreams];
    });
    (0, _defineProperty2.default)(this, "loadDataStreams", dataStreams => {
      var _dataStreams$data_str;
      this.dataStreams = ((_dataStreams$data_str = dataStreams.data_streams) !== null && _dataStreams$data_str !== void 0 ? _dataStreams$data_str : []).map(({
        name
      }) => name).sort();
      this.perDataStreamIndices = dataStreams.data_streams.reduce((acc, {
        name,
        indices
      }) => {
        acc[name] = indices.map(index => index.index_name);
        return acc;
      }, {});
    });
    (0, _defineProperty2.default)(this, "clearDataStreams", () => {
      this.dataStreams = [];
    });
  }
}
exports.DataStream = DataStream;