"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.track = void 0;
var _get_endpoint_from_position = require("../../../lib/autocomplete/get_endpoint_from_position");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const track = (requests, editor, trackUiMetric) => {
  const coreEditor = editor.getCoreEditor();
  // `getEndpointFromPosition` gets values from the server-side generated JSON files which
  // are a combination of JS, automatically generated JSON and manual overrides. That means
  // the metrics reported from here will be tied to the definitions in those files.
  // See src/legacy/core_plugins/console/server/api_server/spec
  const endpointDescription = (0, _get_endpoint_from_position.getEndpointFromPosition)(coreEditor, coreEditor.getCurrentPosition(), editor.parser);
  if (requests[0] && endpointDescription) {
    var _endpointDescription$;
    const eventName = `${requests[0].method}_${(_endpointDescription$ = endpointDescription.id) !== null && _endpointDescription$ !== void 0 ? _endpointDescription$ : 'unknown'}`;
    trackUiMetric.count(eventName);
  }
};
exports.track = track;