"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelsContainer = PanelsContainer;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _resizer = require("./resizer");
var _contexts = require("../../contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const initialState = {
  isDragging: false,
  currentResizerPos: -1
};
const pxToPercent = (proportion, whole) => proportion / whole * 100;
function PanelsContainer({
  children,
  className,
  onPanelWidthChange,
  resizerClassName
}) {
  const childrenArray = _react.Children.toArray(children);
  const [firstChild, secondChild] = childrenArray;
  const registryRef = (0, _react.useRef)(new _contexts.PanelRegistry());
  const containerRef = (0, _react.useRef)(null);
  const [state, setState] = (0, _react.useState)(initialState);
  const getContainerWidth = () => {
    return containerRef.current.getBoundingClientRect().width;
  };
  const handleMouseDown = (0, _react.useCallback)(event => {
    setState({
      ...state,
      isDragging: true,
      currentResizerPos: event.clientX
    });
  }, [state]);
  const handleKeyDown = (0, _react.useCallback)(ev => {
    const {
      key
    } = ev;
    if (key === _eui.keys.ARROW_LEFT || key === _eui.keys.ARROW_RIGHT) {
      ev.preventDefault();
      const {
        current: registry
      } = registryRef;
      const [left, right] = registry.getPanels();
      const leftPercent = left.width - (key === _eui.keys.ARROW_LEFT ? 1 : -1);
      const rightPercent = right.width - (key === _eui.keys.ARROW_RIGHT ? 1 : -1);
      left.setWidth(leftPercent);
      right.setWidth(rightPercent);
      if (onPanelWidthChange) {
        onPanelWidthChange([leftPercent, rightPercent]);
      }
    }
  }, [onPanelWidthChange]);
  (0, _react.useEffect)(() => {
    if (process.env.NODE_ENV !== 'production') {
      // For now we only support bi-split
      if (childrenArray.length > 2) {
        // eslint-disable-next-line no-console
        console.warn('[Split Panels Container] Detected more than two children; ignoring additional children.');
      }
    }
  }, [childrenArray.length]);
  const childrenWithResizer = [firstChild, /*#__PURE__*/_react.default.createElement(_resizer.Resizer, {
    key: 'resizer',
    className: resizerClassName,
    onKeyDown: handleKeyDown,
    onMouseDown: handleMouseDown
  }), secondChild];
  return /*#__PURE__*/_react.default.createElement(_contexts.PanelContextProvider, {
    registry: registryRef.current
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: className,
    ref: containerRef,
    style: {
      display: 'flex',
      height: '100%',
      width: '100%'
    },
    onMouseMove: event => {
      if (state.isDragging) {
        const {
          clientX: x
        } = event;
        const {
          current: registry
        } = registryRef;
        const [left, right] = registry.getPanels();
        const delta = x - state.currentResizerPos;
        const containerWidth = getContainerWidth();
        const leftPercent = pxToPercent(left.getWidth() + delta, containerWidth);
        const rightPercent = pxToPercent(right.getWidth() - delta, containerWidth);
        left.setWidth(leftPercent);
        right.setWidth(rightPercent);
        if (onPanelWidthChange) {
          onPanelWidthChange([leftPercent, rightPercent]);
        }
        setState({
          ...state,
          currentResizerPos: x
        });
      }
    },
    onMouseUp: () => {
      setState(initialState);
    }
  }, childrenWithResizer));
}