"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Panel = Panel;
var _react = _interopRequireWildcard(require("react"));
var _contexts = require("../../contexts");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Panel({
  children,
  className,
  initialWidth = 100,
  style = {}
}) {
  const [width, setWidth] = (0, _react.useState)(`${initialWidth}%`);
  const {
    registry
  } = (0, _contexts.usePanelContext)();
  const divRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    registry.registerPanel({
      width: initialWidth,
      setWidth(value) {
        setWidth(value + '%');
        this.width = value;
      },
      getWidth() {
        return divRef.current.getBoundingClientRect().width;
      }
    });
  }, [initialWidth, registry]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className,
    ref: divRef,
    style: {
      ...style,
      width,
      display: 'flex'
    }
  }, children);
}